/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.domain;

import com.ur.log.logentry.robotmessage.RobotMessageProducer;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import com.ur.safety.GuiReadyEvaluator;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentRegistrationFault;
import com.ur.util.Waiting;
import com.ur.view.constants.errorcodes.ReportLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SafetyEquipmentRegistrationFaultService {
    private final RobotMessageProducer robotMessageProducer;
    private final GuiReadyEvaluator guiReadyEvaluator;
    private final SafetyTextResource safetyTextResource;
    private final List<SafetyEquipmentRegistrationFault> failedRegistrations = new ArrayList<SafetyEquipmentRegistrationFault>();

    @Inject
    public SafetyEquipmentRegistrationFaultService(RobotMessageProducer robotMessageProducer, GuiReadyEvaluator guiReadyEvaluator, SafetyTextResource safetyTextResource) {
        this.robotMessageProducer = robotMessageProducer;
        this.guiReadyEvaluator = guiReadyEvaluator;
        this.safetyTextResource = safetyTextResource;
        this.logErrorsWhenUiReady();
    }

    public void handleFailedRegistrations(String causeOfError, URCapInformation activeURCapInformation) {
        String urCapSymbolicName = this.getURCapSymbolicName(activeURCapInformation);
        SafetyEquipmentRegistrationFault safetyEquipmentRegistrationFault = new SafetyEquipmentRegistrationFault(urCapSymbolicName, causeOfError);
        this.failedRegistrations.add(safetyEquipmentRegistrationFault);
    }

    private String getURCapSymbolicName(URCapInformation activeURCapInformation) {
        return Objects.nonNull(activeURCapInformation) ? activeURCapInformation.getSymbolicName() : "UNKNOWN";
    }

    private void logErrorsWhenUiReady() {
        new Thread(() -> {
            Waiting.until(this.guiReadyEvaluator::isGuiReady, (int)2, (TimeUnit)TimeUnit.MINUTES);
            this.logFailedRegistrations();
        }).start();
    }

    private void logFailedRegistrations() {
        this.failedRegistrations.forEach(this::logFailedRegistration);
    }

    private void logFailedRegistration(SafetyEquipmentRegistrationFault safetyEquipmentRegistrationFault) {
        String errorMessage = this.safetyTextResource.safetyEquipmentFailedRegistration(safetyEquipmentRegistrationFault.getCauseOfFault(), safetyEquipmentRegistrationFault.getSymbolicName());
        this.robotMessageProducer.generateAndNotify(ReportLevel.FAULT, errorMessage);
    }
}

