/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.ui;

import com.ur.safety.SafetyTextResource;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService;
import com.ur.safety.urcapequipment.ui.SafetyDeviceRegistrationValidator;
import com.ur.safety.urcapequipment.ui.SafetyDeviceToggleComponent;
import com.ur.safety.util.domain.UpdateParentWithFormState;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.validation.FormValidation;
import com.ur.swing.validation.SwingFormValidation;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

@Singleton
public class SafetyDevicePanel
extends JPanel
implements SafetyLockListener {
    private final SafetyLock safetyLock;
    private final ViewContext viewContext;
    private final SafetyTextResource safetyTextResource;
    private final SafetyEquipmentContributionService safetyEquipmentContributionService;
    private JPanel safetyDevicesPanel;
    private final List<SafetyDeviceToggleComponent> safetyDeviceToggleComponents = new ArrayList<SafetyDeviceToggleComponent>();
    private final SwingFormValidation safetyFormValidation;

    @Inject
    public SafetyDevicePanel(SafetyLock safetyLock, ViewContext viewContext, SafetyTextResource safetyTextResource, SafetyEquipmentContributionService safetyEquipmentContributionService) {
        this.safetyLock = safetyLock;
        this.viewContext = viewContext;
        this.safetyTextResource = safetyTextResource;
        this.safetyEquipmentContributionService = safetyEquipmentContributionService;
        this.safetyFormValidation = new SwingFormValidation();
        this.safetyDevicesPanel = this.createSafetyDevicePanel();
        this.initComponents();
        safetyLock.addSafetyLockListener(this);
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setBorder(new CompoundBorder(this.getBorder(), (Border)new CardBorder(this.safetyTextResource.urcapSafetyEquipmentHeader())));
        this.buildAndUpdateLayout();
    }

    private void buildAndUpdateLayout() {
        this.repaint();
        this.revalidate();
    }

    private JPanel createSafetyDevicePanel() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        this.createFormComponents(formBuilder);
        JPanel panel = formBuilder.getPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        return panel;
    }

    private void createFormComponents(FormBuilder formBuilder) {
        formBuilder.label(this.safetyTextResource.urcapSafetyEquipmentDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end();
        this.safetyDeviceToggleComponents.addAll(this.safetyEquipmentContributionService.getDevices().stream().map(this::getSafetyDeviceToggleComponent).peek(it -> it.buildSafetyDeviceComponent(formBuilder)).collect(Collectors.toList()));
    }

    private SafetyDeviceToggleComponent getSafetyDeviceToggleComponent(SafetyEquipment safetyEquipment) {
        ActionListener registrationActionListener = actionEvent -> this.safetyFormValidation.validate();
        return new SafetyDeviceToggleComponent(this.safetyEquipmentContributionService, this.viewContext, safetyEquipment, registrationActionListener);
    }

    public void resetUI(UpdateParentWithFormState formStatus) {
        this.recreateSafetyDevicePanel();
        this.updateSwitches();
        this.repaint();
        this.revalidate();
        this.bindFormValidation(formStatus);
    }

    @Override
    public void doUnlock() {
        this.safetyDeviceToggleComponents.forEach(SafetyDeviceToggleComponent::enableComponent);
    }

    @Override
    public void doLock() {
        this.safetyDeviceToggleComponents.forEach(SafetyDeviceToggleComponent::disableComponent);
    }

    private void recreateSafetyDevicePanel() {
        this.remove(this.safetyDevicesPanel);
        this.safetyDeviceToggleComponents.clear();
        this.safetyDevicesPanel = this.createSafetyDevicePanel();
        this.add(this.safetyDevicesPanel);
    }

    private void updateSwitches() {
        this.safetyDeviceToggleComponents.forEach(SafetyDeviceToggleComponent::updateSwitch);
        this.enableSwitchesWhenSafetyUnlocked();
    }

    private void enableSwitchesWhenSafetyUnlocked() {
        if (!this.safetyLock.isLocked()) {
            this.safetyDeviceToggleComponents.forEach(SafetyDeviceToggleComponent::enableComponent);
        }
    }

    public List<SafetyDeviceToggleComponent> getCheckBoxes() {
        return Collections.unmodifiableList(this.safetyDeviceToggleComponents);
    }

    public void bindFormValidation(UpdateParentWithFormState formStatus) {
        this.safetyFormValidation.clearForm();
        this.safetyFormValidation.addFormListener((FormValidation.FormListener)formStatus);
        this.safetyDeviceToggleComponents.forEach(this::addErrorValidators);
        this.safetyFormValidation.validate();
    }

    private void addErrorValidators(SafetyDeviceToggleComponent safetyDeviceToggleComponent) {
        SafetyDeviceRegistrationValidator safetyDeviceRegistrationValidator = new SafetyDeviceRegistrationValidator(safetyDeviceToggleComponent);
        this.safetyFormValidation.addErrorValidation((JComponent)safetyDeviceToggleComponent.getEnablementSwitch(), (FormValidation.Validator)safetyDeviceRegistrationValidator);
    }
}

