/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.ui;

import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.AbstractSafetySetupToHtmlRenderer;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.urcapequipment.domain.SafetyDeviceConfiguration;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.util.swing.HTML;
import java.util.ArrayList;
import javax.inject.Inject;

public class SafetyDeviceToHtmlRenderer
extends AbstractSafetySetupToHtmlRenderer {
    private static final String LEFT_ALIGN_ATTRIBUTE = "align=left";

    @Inject
    public SafetyDeviceToHtmlRenderer(SafetyTextResource textResource, SafetySetupPanesLookAndFeel lookAndFeel) {
        super(textResource, lookAndFeel);
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        return new HTMLPage(this.textResource.safetyEquipment(), this.createSafetyDeviceHtml((SafetyDeviceConfiguration)safetySetup.getComponent(SafetyDeviceConfiguration.class)));
    }

    private String createSafetyDeviceHtml(SafetyDeviceConfiguration safetyDeviceConfiguration) {
        return HTML.table((int)this.lookAndFeel.panelWidth, (String[])this.generateRows(safetyDeviceConfiguration));
    }

    private String[] generateRows(SafetyDeviceConfiguration safetyDeviceConfiguration) {
        ArrayList<String> rows = new ArrayList<String>();
        AlternatingBackgroundRowGenerator rowGenerator = new AlternatingBackgroundRowGenerator();
        String headerRow = rowGenerator.generate(HTML.tableHeaderWithProperties((String)LEFT_ALIGN_ATTRIBUTE, (String)this.textResource.safetyDeviceName()), HTML.tableHeaderWithProperties((String)LEFT_ALIGN_ATTRIBUTE, (String)this.textResource.safetyDeviceId()), HTML.tableHeaderWithProperties((String)LEFT_ALIGN_ATTRIBUTE, (String)this.textResource.safetyDeviceChecksum()));
        rows.add(headerRow);
        safetyDeviceConfiguration.getSafetyDevices().forEach(it -> {
            boolean bl = rows.add(rowGenerator.generate(HTML.tableCell((String)it.getName()), HTML.tableCell((String)it.getUuidAsString()), HTML.tableCell((String)it.getChecksumAsString())));
        });
        return rows.toArray(new String[0]);
    }
}

