/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.urcapequipment.ui;

import com.ur.safety.urcapequipment.domain.SafetyEquipment;
import com.ur.safety.urcapequipment.domain.SafetyEquipmentContributionService;
import com.ur.safety.urcapequipment.ui.ChecksumLabel;
import com.ur.safety.urcapequipment.ui.DeviceNotRegisteredLabel;
import com.ur.safety.urcapequipment.ui.EquipmentOnOffSwitch;
import com.ur.swing.FormBuilder;
import com.ur.swing.OnOffSwitch;
import com.ur.swing.ViewContext;
import java.awt.event.ActionListener;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SafetyDeviceToggleComponent {
    private final SafetyEquipmentContributionService registrationService;
    private final SafetyEquipment safetyEquipment;
    private final EquipmentOnOffSwitch enablementSwitch;
    private final ChecksumLabel safetyChecksumLabel;
    private final JLabel safetyErrorLabel;

    public SafetyDeviceToggleComponent(SafetyEquipmentContributionService registrationService, ViewContext viewContext, SafetyEquipment safetyEquipment, ActionListener registrationActionListener) {
        this.registrationService = registrationService;
        this.safetyEquipment = safetyEquipment;
        this.safetyChecksumLabel = new ChecksumLabel(safetyEquipment);
        this.enablementSwitch = new EquipmentOnOffSwitch(safetyEquipment, registrationService, e -> this.safetyChecksumLabel.setVisible(e.getStateChange() == 1), registrationActionListener);
        this.safetyErrorLabel = new DeviceNotRegisteredLabel(viewContext);
    }

    public void buildSafetyDeviceComponent(FormBuilder formBuilder) {
        formBuilder.buttonRow((JComponent)this.getEnablementSwitch(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.LEFT_ALIGN, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.safetyChecksumLabel, new FormBuilder.PanelConstraints[0]).end();
        this.getSafetyDeviceRegistrationErrorLabel().ifPresent(it -> {
            FormBuilder formBuilder2 = formBuilder.component((JComponent)it, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end(2);
        });
    }

    public void enableComponent() {
        this.enablementSwitch.setEnabled(true);
    }

    public void disableComponent() {
        this.enablementSwitch.setEnabled(false);
    }

    public boolean isSelected() {
        return this.enablementSwitch.isSelected();
    }

    public void updateSwitch() {
        this.enablementSwitch.setSelected(this.safetyEquipment.isEnabled());
        this.safetyChecksumLabel.setVisible(this.safetyEquipment.isEnabled());
    }

    public void showSafetyDeviceRegistrationErrorLabel() {
        this.safetyErrorLabel.setVisible(true);
    }

    public void hideSafetyDeviceRegistrationErrorLabel() {
        this.safetyErrorLabel.setVisible(false);
    }

    public OnOffSwitch getEnablementSwitch() {
        return this.enablementSwitch;
    }

    public boolean hasSafetyDeviceRegistrationError() {
        return this.registrationService.isDeviceEnabledAndMissingRegistration(this.safetyEquipment);
    }

    private Optional<JLabel> getSafetyDeviceRegistrationErrorLabel() {
        if (this.hasSafetyDeviceRegistrationError()) {
            return Optional.of(this.safetyErrorLabel);
        }
        return Optional.empty();
    }

    public void setSelected(boolean b) {
        this.enablementSwitch.setSelected(b);
    }

    public JLabel getChecksumLabel() {
        return this.safetyChecksumLabel;
    }

    public SafetyEquipment getSafetyDevice() {
        return this.safetyEquipment;
    }
}

