/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.util.domain;

import com.ur.bean.ReflectUtils;
import com.ur.lang.EqualsUtil;
import com.ur.safety.util.domain.IconWithTextLabel;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CompoundRegistration;
import com.ur.swing.IconAndLabelProvider;
import com.ur.swing.IconProvider;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxUtils {
    public static void selectWithLabel(JComboBox comboBox, String nameLabel) {
        if (ComboBoxUtils.setValueMatchingString(comboBox, nameLabel) == null) {
            comboBox.setSelectedIndex(0);
        }
    }

    public static void selectItem(JComboBox comboBox, Object value) {
        if (value == null) {
            comboBox.setSelectedIndex(0);
        } else {
            comboBox.setSelectedItem(value);
            if (comboBox.getSelectedItem() != value) {
                comboBox.setSelectedIndex(0);
            }
        }
    }

    private static Object setValueMatchingString(JComboBox comboBox, String nameLabel) {
        int i = 0;
        while (i < comboBox.getItemCount()) {
            Object item = comboBox.getItemAt(i);
            if (item != null) {
                if (item instanceof IconWithTextLabel && EqualsUtil.equals((Object)nameLabel, (Object)((IconWithTextLabel)item).getText())) {
                    comboBox.setSelectedIndex(i);
                    return item;
                }
                if (EqualsUtil.equals((Object)nameLabel, (Object)item.toString())) {
                    comboBox.setSelectedIndex(i);
                    return item;
                }
            }
            ++i;
        }
        return null;
    }

    public static BindingRegistration bindEnsureOnlyOneWithValue(final Object fallbackValue, final JComboBox ... comboBoxes) {
        CompoundRegistration result = new CompoundRegistration();
        int i = 0;
        while (i < comboBoxes.length) {
            final int index = i++;
            final ActionListener ensureOnlyOneHasValue = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox trigger = (JComboBox)e.getSource();
                    if (trigger.getSelectedItem() != fallbackValue) {
                        this.resetOtherComboBoxesWithMatchingSelectedValueToFallbackValue(trigger);
                    }
                }

                private void resetOtherComboBoxesWithMatchingSelectedValueToFallbackValue(JComboBox trigger) {
                    JComboBox[] jComboBoxArray = comboBoxes;
                    int n = comboBoxes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object value;
                        JComboBox otherComboBox = jComboBoxArray[n2];
                        if (otherComboBox != trigger && (value = otherComboBox.getSelectedItem()) == trigger.getSelectedItem()) {
                            otherComboBox.setSelectedItem(fallbackValue);
                        }
                        ++n2;
                    }
                }
            };
            comboBoxes[index].addActionListener(ensureOnlyOneHasValue);
            result.add(new BindingRegistration(){

                public void removeRegistration() {
                    comboBoxes[index].removeActionListener(ensureOnlyOneHasValue);
                }
            });
        }
        return result;
    }

    public static BindingRegistration bindToField(final JComboBox comboBox, final Object modelToBind, final String propertyInModel) {
        Object property = ReflectUtils.getProperty((Object)modelToBind, (String)propertyInModel, (Object)comboBox.getSelectedItem());
        comboBox.getModel().setSelectedItem(property);
        final ActionListener updateOnChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = comboBox.getSelectedItem();
                ReflectUtils.setProperty((Object)modelToBind, (String)propertyInModel, (Object)selectedItem);
            }
        };
        comboBox.addActionListener(updateOnChange);
        return new BindingRegistration(){

            public void removeRegistration() {
                comboBox.removeActionListener(updateOnChange);
            }
        };
    }

    public static <T> BindingRegistration bindToField(final JComboBox comboBox, final GetSetModel<T> modelToBind) {
        T property = modelToBind.get();
        comboBox.getModel().setSelectedItem(property);
        final ActionListener updateOnChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem = comboBox.getSelectedItem();
                modelToBind.set(selectedItem);
            }
        };
        final PropertyChangeListener updateFromModel = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object selectedItem = comboBox.getModel().getSelectedItem();
                if (modelToBind.get() != selectedItem) {
                    comboBox.getModel().setSelectedItem(modelToBind.get());
                }
            }
        };
        comboBox.addActionListener(updateOnChange);
        modelToBind.addPropertyChangeListener(updateFromModel);
        return new BindingRegistration(){

            public void removeRegistration() {
                comboBox.removeActionListener(updateOnChange);
                modelToBind.removePropertyChangeListener(updateFromModel);
            }
        };
    }

    public static void setIconProvider(JComboBox comboBox, final IconProvider provider) {
        ListCellRenderer renderer = new ListCellRenderer(){
            JLabel result = new JLabel();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof String) {
                    int i = 0;
                    while (i < list.getModel().getSize()) {
                        Object object = list.getModel().getElementAt(i);
                        if (EqualsUtil.equals((Object)object.toString(), (Object)value)) {
                            value = object;
                            break;
                        }
                        ++i;
                    }
                }
                Icon icon = provider.getIcon(value);
                this.result.setIcon(icon);
                this.result.setText(value.toString());
                return this.result;
            }
        };
        comboBox.setRenderer(renderer);
    }

    public static <T> void setIconAndTextRenderer(JComboBox comboBox, IconAndLabelProvider<T> iconAndTextProvider, Icon defaultNoIcon) {
        IconAndTextListCellRenderer renderer = new IconAndTextListCellRenderer(defaultNoIcon, iconAndTextProvider);
        comboBox.setRenderer(renderer);
    }

    public static void addAll(DefaultComboBoxModel model, Object ... collectionsAndSingleObjects) {
        Object[] objectArray = collectionsAndSingleObjects;
        int n = collectionsAndSingleObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object each = objectArray[n2];
            if (each instanceof Iterable) {
                for (Object eachCollection : (Iterable)each) {
                    model.addElement(eachCollection);
                }
            } else {
                model.addElement(each);
            }
            ++n2;
        }
    }

    public static boolean contains(JComboBox selection, Object item) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)selection.getModel();
        int i = 0;
        while (i < model.getSize()) {
            if (EqualsUtil.equals(model.getElementAt(i), (Object)item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addItem(JComboBox selection, Object item) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)selection.getModel();
        if (model.getIndexOf(item) == -1) {
            model.addElement(item);
        }
    }

    public static interface GetSetModel<T> {
        public T get();

        public void set(T var1);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static final class IconAndTextListCellRenderer<T>
    extends DefaultComboBoxRenderer {
        private final Icon defaultNoIcon;
        private final IconAndLabelProvider<T> iconAndTextProvider;

        private IconAndTextListCellRenderer(Icon defaultNoIcon, IconAndLabelProvider<T> iconAndTextProvider) {
            this.defaultNoIcon = defaultNoIcon;
            this.iconAndTextProvider = iconAndTextProvider;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                int i = 0;
                while (i < list.getModel().getSize()) {
                    Object object = list.getModel().getElementAt(i);
                    if (EqualsUtil.equals((Object)object.toString(), (Object)value)) {
                        value = object;
                        break;
                    }
                    ++i;
                }
            }
            if (value instanceof IconWithTextLabel) {
                IconWithTextLabel labelProvider = (IconWithTextLabel)value;
                this.setIcon(labelProvider.getIcon());
                this.setText(labelProvider.getText());
            } else if (this.iconAndTextProvider != null) {
                this.setIcon(this.iconAndTextProvider.getIcon(value));
                this.setText(this.iconAndTextProvider.getText(value));
            } else {
                this.setIcon(this.defaultNoIcon);
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setBorder(null);
            this.setPreferredSize(new Dimension(230, 22));
            return this;
        }
    }
}

