/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.util.domain;

import com.ur.lang.HashCodeBuilder;
import com.ur.math.Revolution;
import com.ur.monitor.model.JointType;

public class Q {
    protected Revolution[] jointRevolutions;
    protected int dimension = JointType.values().length;

    public Q() {
        this.jointRevolutions = new Revolution[this.dimension];
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType j = jointTypeArray[n2];
            this.jointRevolutions[j.getJointNumber()] = new Revolution();
            ++n2;
        }
    }

    public Q(Revolution[] qs) {
        this();
        if (qs == null) {
            return;
        }
        if (qs.length == JointType.values().length) {
            JointType[] jointTypeArray = JointType.values();
            int n = jointTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JointType j = jointTypeArray[n2];
                int joint = j.getJointNumber();
                this.jointRevolutions[joint] = new Revolution(qs[joint]);
                ++n2;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Q(double[] angles) {
        this();
        if (angles == null) {
            return;
        }
        if (angles.length == JointType.values().length) {
            JointType[] jointTypeArray = JointType.values();
            int n = jointTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JointType j = jointTypeArray[n2];
                int joint = j.getJointNumber();
                this.jointRevolutions[joint] = new Revolution(angles[joint]);
                ++n2;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void setJoint(JointType j, Revolution value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.jointRevolutions[j.getJointNumber()] = value;
    }

    public void setJoint(JointType j, int rev, double angle) {
        int joint = j.getJointNumber();
        this.jointRevolutions[joint] = new Revolution(rev, angle);
    }

    public Revolution getJoint(JointType j) {
        return this.jointRevolutions[j.getJointNumber()];
    }

    public int[] getRevolutions() {
        int[] result = new int[this.dimension];
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType j = jointTypeArray[n2];
            int joint = j.getJointNumber();
            result[joint] = this.jointRevolutions[joint].getRevolutions();
            ++n2;
        }
        return result;
    }

    public double[] getAngles() {
        double[] result = new double[this.dimension];
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType j = jointTypeArray[n2];
            int joint = j.getJointNumber();
            result[joint] = this.jointRevolutions[joint].getOffsetAngle();
            ++n2;
        }
        return result;
    }

    public double[] getTotalAngles() {
        double[] result = new double[this.dimension];
        JointType[] jointTypeArray = JointType.values();
        int n = jointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            JointType j = jointTypeArray[n2];
            int joint = j.getJointNumber();
            result[joint] = this.jointRevolutions[joint].getTotalAngle();
            ++n2;
        }
        return result;
    }

    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.dimension) {
            result = String.valueOf(result) + this.jointRevolutions[i].toString() + " ";
            ++i;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof Q) {
            Q qv = (Q)o;
            JointType[] jointTypeArray = JointType.values();
            int n = jointTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                JointType j = jointTypeArray[n2];
                if (!qv.getJoint(j).equals((Object)this.getJoint(j))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(4).append(this.dimension).append((Object[])this.jointRevolutions).toHashCode();
    }
}

