/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.util.domain;

import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.resources.ViewImageResource;
import com.ur.swing.validation.FormValidation;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class UpdateParentWithFormState
implements FormValidation.FormListener<JComponent> {
    private Errorable.Status status = Errorable.Status.OK;
    private ShowIcon showIconForComponent;
    private Component component;
    private List<Errorable.StatusListener> statusListeners = new ArrayList<Errorable.StatusListener>();

    public UpdateParentWithFormState(ShowIcon showIconForParent, Component component) {
        this.showIconForComponent = showIconForParent;
        this.component = component;
    }

    public void formHasError(FormValidation<JComponent> validation) {
        this.status = Errorable.Status.ERROR;
        this.showIconForComponent.show(ViewImageResource.formError(), this.component);
        this.fireStatusUpdate();
    }

    public void formHasWarning(FormValidation<JComponent> validation) {
        this.status = Errorable.Status.WARNING;
        this.showIconForComponent.show(ViewImageResource.formWarning(), this.component);
        this.fireStatusUpdate();
    }

    public void formIsOK(FormValidation<JComponent> validation) {
        this.status = Errorable.Status.OK;
        this.showIconForComponent.clearIcon(this.component);
        this.fireStatusUpdate();
    }

    private void fireStatusUpdate() {
        for (Errorable.StatusListener each : this.statusListeners) {
            each.statusChanged(this.status);
        }
    }

    public void addStatusListener(Errorable.StatusListener listener) {
        if (!this.statusListeners.contains(listener)) {
            this.statusListeners.add(listener);
        }
    }

    public void removeStatusListener(Errorable.StatusListener listener) {
        this.statusListeners.remove(listener);
    }

    public Errorable.Status getOverallStatus() {
        return this.status;
    }
}

