/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.util.infrastructure;

import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.boundaries.externalapi.ElementDefinitionState;
import com.ur.safety.boundaries.infrastructure.BoundariesPanelImpl;
import com.ur.safety.util.domain.ComboBoxUtils;
import com.ur.safety.util.externalapi.SelectFeaturePresenter;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.FormBuilder;
import com.ur.swing.IconAndLabelProvider;
import com.ur.swing.WidgetFactory;
import gui.polyscope.setup.safety.FeatureIconAndLabelProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectFeature
implements ActionListener,
FormBuilder.Components {
    private final Object UNDEFINED = null;
    private final SelectFeaturePresenter presenter;
    private final JLabel label;
    private final JPanel labelPanel;
    private final JComboBox selection;
    private final JButton synchronize;

    public SelectFeature(SelectFeaturePresenter presenter, WidgetFactory widgetFactory, SafetyTextResource text) {
        this.presenter = presenter;
        FeatureIconAndLabelProvider provider = new FeatureIconAndLabelProvider(text.Undefined());
        this.label = widgetFactory.createLabel(text.safetyHeaderCopyFrom());
        this.label.setHorizontalTextPosition(2);
        this.synchronize = widgetFactory.createButton((Action)((Object)new SynchronizeFeatureAction()));
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, 0));
        this.labelPanel.setBorder(BorderFactory.createEmptyBorder());
        this.labelPanel.add(this.label);
        this.labelPanel.add(Box.createHorizontalGlue());
        this.labelPanel.add(this.synchronize);
        this.selection = widgetFactory.createComboBox((IconAndLabelProvider)provider, new Object[0]);
        this.selection.setModel(new DefaultComboBoxModel());
        this.selection.addActionListener(this);
        this.selection.setName(BoundariesPanelImpl.FEATURES_COMBO_BOX);
    }

    public void addTo(FormBuilder formBuilder, FormBuilder.PanelConstraints ... constraints) {
        formBuilder.component((JComponent)this.labelPanel, constraints).end().component((JComponent)this.selection, constraints).end();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GeomFeature safetyMode = (GeomFeature)this.selection.getSelectedItem();
        this.presenter.selectFeature((SpatialFeature)safetyMode);
    }

    public void setFeatures(Iterable<SpatialFeature> features) {
        this.selection.removeActionListener(this);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>();
        model.addElement(this.UNDEFINED);
        ComboBoxUtils.addAll(model, features);
        this.selection.setModel(model);
        this.selection.addActionListener(this);
    }

    public void setSelection(GeomFeature selectedFeature) {
        this.selection.removeActionListener(this);
        ComboBoxUtils.selectItem(this.selection, selectedFeature);
        this.selection.addActionListener(this);
    }

    public void setSelectedFeatureState(ElementDefinitionState selectedFeatureState) {
        switch (selectedFeatureState) {
            case CHANGED: 
            case REMOVED: {
                this.label.setIcon(ViewImageResource.formWarning());
                break;
            }
            default: {
                this.label.setIcon(null);
            }
        }
    }

    public void setEnabledSelection(boolean enabled) {
        this.selection.setEnabled(enabled);
    }

    public void setEnabledSynchronization(boolean enabled) {
        this.synchronize.setEnabled(enabled);
    }

    private class SynchronizeFeatureAction
    extends AbstractActionDefinition {
        private SynchronizeFeatureAction() {
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("SmallIcon", ViewImageResource.refreshSmall());
        }

        public void actionPerformed(ActionEvent e) {
            SelectFeature.this.presenter.synchronizeFeature();
        }
    }
}

