/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.util.infrastructure;

import com.ur.polyscope.tcp.TCP;
import com.ur.resources.ViewImageResource;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.util.domain.ComboBoxUtils;
import com.ur.safety.util.externalapi.SelectTCPPresenter;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.FormBuilder;
import com.ur.swing.IconAndLabelProvider;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Named;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectTCP
implements ActionListener,
FormBuilder.Components {
    private final SelectTCPPresenter presenter;
    private final JLabel label;
    private final JPanel labelPanel;
    private final JComboBox selection;
    private final JButton synchronize;

    public SelectTCP(SelectTCPPresenter presenter, ViewContext viewContext, final @Named(value="tcp-renderer") @Named(value="tcp-renderer") RenderingStrategy strategy) {
        this.presenter = presenter;
        final SafetyTextResource text = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        IconAndLabelProvider<Object> provider = new IconAndLabelProvider<Object>(){

            public Icon getIcon(Object o) {
                return null;
            }

            public String getText(Object value) {
                if (value == Definition.CUSTOM) {
                    return SelectTCP.this.selection.getSelectedItem() == Definition.CUSTOM ? text.custom() : "";
                }
                if (value == Definition.ORIGIN) {
                    return text.origin();
                }
                return strategy.getText(value);
            }
        };
        this.label = widgetFactory.createLabel(text.copyFromTCP());
        this.label.setHorizontalTextPosition(2);
        this.synchronize = widgetFactory.createButton((Action)((Object)new SynchronizeFeatureAction()));
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, 0));
        this.labelPanel.setBorder(BorderFactory.createEmptyBorder());
        this.labelPanel.add(this.label);
        this.labelPanel.add(Box.createHorizontalGlue());
        this.labelPanel.add(this.synchronize);
        this.selection = widgetFactory.createComboBox((IconAndLabelProvider)provider, new Object[0]);
        this.selection.setModel(new DefaultComboBoxModel());
        this.selection.addActionListener(this);
        this.selection.setName("tcpComboBox.WorkpiecePanel");
        this.selection.setPreferredSize(this.selection.getPreferredSize());
    }

    public void addTo(FormBuilder formBuilder, FormBuilder.PanelConstraints ... constraints) {
        formBuilder.component((JComponent)this.labelPanel, constraints).end().component((JComponent)this.selection, constraints).end();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object current = this.selection.getSelectedItem();
        if (current instanceof TCP) {
            this.presenter.selectTCP((TCP)current);
        } else if (current == Definition.ORIGIN) {
            this.presenter.selectDefaultTCP();
        }
    }

    public void setTCPs(Iterable<TCP> tcps) {
        this.selection.removeActionListener(this);
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        ComboBoxUtils.addAll(model, new Object[]{tcps, Definition.ORIGIN});
        this.selection.setModel(model);
        this.selection.addActionListener(this);
    }

    public void setSelection(TCP tcp) {
        if (this.selection.getModel().getElementAt(0) == Definition.CUSTOM) {
            ((DefaultComboBoxModel)this.selection.getModel()).removeElement((Object)Definition.CUSTOM);
        }
        this.selection.removeActionListener(this);
        if (ComboBoxUtils.contains(this.selection, tcp)) {
            ComboBoxUtils.selectItem(this.selection, tcp);
        } else {
            ComboBoxUtils.selectItem(this.selection, (Object)Definition.CUSTOM);
        }
        this.selection.addActionListener(this);
    }

    public void setSelection(Definition definition) {
        this.selection.removeActionListener(this);
        if (definition == Definition.CUSTOM) {
            if (this.selection.getModel().getElementAt(0) != Definition.CUSTOM) {
                ((DefaultComboBoxModel)this.selection.getModel()).insertElementAt(Definition.CUSTOM, 0);
            }
        } else {
            ((DefaultComboBoxModel)this.selection.getModel()).removeElement((Object)Definition.CUSTOM);
        }
        ComboBoxUtils.selectItem(this.selection, (Object)definition);
        this.selection.addActionListener(this);
    }

    public void setSynchronizationPossible(boolean synchronizationPossible) {
        this.synchronize.setEnabled(synchronizationPossible && this.selection.isEnabled());
        this.label.setIcon(synchronizationPossible ? ViewImageResource.formWarning() : null);
    }

    public void setEnabled(boolean isEnabled) {
        this.selection.setEnabled(isEnabled);
        if (!isEnabled) {
            this.synchronize.setEnabled(false);
        }
    }

    public static enum Definition {
        ORIGIN,
        FROM_TCP,
        CUSTOM;

    }

    private class SynchronizeFeatureAction
    extends AbstractActionDefinition {
        private SynchronizeFeatureAction() {
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("SmallIcon", ViewImageResource.refreshSmall());
        }

        public void actionPerformed(ActionEvent e) {
            SelectTCP.this.presenter.synchronizeTCP();
        }
    }
}

