/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.util.infrastructure;

import com.ur.safety.boundaries.infrastructure.BoundariesPanelImpl;
import com.ur.safety.util.externalapi.CoordinateInputs;
import com.ur.safety.util.externalapi.CoordinateValues;
import com.ur.safety.util.externalapi.SetCoordinatesBinder;
import com.ur.safety.util.externalapi.SetCoordinatesPresenter;
import com.ur.swing.DimensionUtils;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputView;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.NumberField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SetCoordinates<E extends Enum<E>>
implements ActionListener,
FormBuilder.Components {
    private final Class<E> coordinateEnum;
    private final SetCoordinatesPresenter<E> presenter;
    private final FieldMap<E> fieldMap;
    private final Map<E, JPanel> panelMap;
    private final SetCoordinatesBinder<E> binder;

    public SetCoordinates(Class<E> coordinateType, SetCoordinatesPresenter<E> presenter, SetCoordinatesBinder<E> binder, WidgetFactory widgetFactory) {
        this.coordinateEnum = coordinateType;
        this.presenter = presenter;
        this.fieldMap = new FieldMap<E>(coordinateType);
        this.panelMap = new EnumMap<E, JPanel>(coordinateType);
        this.binder = binder;
        int labelWidth = this.getMaxLabelWidth((Enum[])coordinateType.getEnumConstants());
        Enum[] enumArray = (Enum[])coordinateType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum each = enumArray[n2];
            NumberField field = widgetFactory.createNumberField((ActionListener)this);
            field.setName(BoundariesPanelImpl.SetCoordinates.NUMBER_FIELD.componentNameFor(each));
            this.fieldMap.put(each, field);
            this.panelMap.put(each, this.createPanel(binder.getLabelText(each), field, labelWidth));
            ++n2;
        }
        binder.bindCoordinates(this.fieldMap);
    }

    public void addTo(FormBuilder formBuilder, FormBuilder.PanelConstraints ... constraints) {
        Enum[] enumArray = (Enum[])this.coordinateEnum.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum each = enumArray[n2];
            formBuilder.component((JComponent)this.panelMap.get(each), constraints).end();
            ++n2;
        }
    }

    public void setCoordinate(CoordinateValues<E> value) {
        Enum[] enumArray = (Enum[])this.coordinateEnum.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum each = enumArray[n2];
            NumberField field = this.fieldMap.getField(each);
            field.removeActionListener((ActionListener)this);
            field.setValue((Object)value.getValue(each));
            field.addActionListener((ActionListener)this);
            ++n2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CoordinateValues value = new CoordinateValues<E>(){

            @Override
            public double getValue(E key) {
                return (Double)SetCoordinates.this.fieldMap.getField(key).getValue();
            }
        };
        this.presenter.setCoordinates(value);
    }

    public void setEnabled(boolean enabled) {
        for (NumberField each : this.fieldMap.values()) {
            each.setEnabled(enabled);
        }
    }

    private int getMaxLabelWidth(E[] constants) {
        Font font = UIManager.getFont("Label.font");
        int maxWidth = 0;
        E[] EArray = constants;
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            E each = EArray[n2];
            String text = this.binder.getLabelText(each);
            int width = DimensionUtils.getLabelTextWidth((Font)font, (String)text);
            if (width > maxWidth) {
                maxWidth = width;
            }
            ++n2;
        }
        return maxWidth;
    }

    private JPanel createPanel(String text, NumberField field, int textWidth) {
        JPanel result = new JPanel();
        JLabel label = new JLabel(text);
        int borderRightWidth = 10;
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, borderRightWidth));
        label.setHorizontalAlignment(2);
        int labelWidth = textWidth + borderRightWidth;
        label.setPreferredSize(new Dimension(labelWidth, -1));
        int containerWidth = 320 - labelWidth;
        field.setNumberFieldWidth(containerWidth, 100);
        result.setLayout(new BoxLayout(result, 0));
        result.setBorder(BorderFactory.createEmptyBorder());
        result.add(label);
        result.add(Box.createHorizontalGlue());
        result.add((Component)field);
        field.addActionListener((ActionListener)this);
        return result;
    }

    private static final class FieldMap<E extends Enum<E>>
    implements CoordinateInputs<E> {
        private final Map<E, NumberField> fieldMap;

        FieldMap(Class<E> coordinateEnum) {
            this.fieldMap = new EnumMap<E, NumberField>(coordinateEnum);
        }

        @Override
        public InputView getInput(E key) {
            return (InputView)this.fieldMap.get(key);
        }

        void put(E each, NumberField field) {
            this.fieldMap.put(each, field);
        }

        NumberField getField(E each) {
            return this.fieldMap.get(each);
        }

        Iterable<NumberField> values() {
            return this.fieldMap.values();
        }
    }
}

