/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.util.infrastructure;

import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.resources.ViewImageResource;
import com.ur.swing.DocumentUpdateListener;
import com.ur.swing.number.NumberField;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.DocumentListener;

public class SimpleSwingFormValidation {
    private Map<JComponent, Errorable.Status> componentStatus;
    private JComponent owner;
    private ShowIcon showIcon;

    public SimpleSwingFormValidation(JComponent owner, ShowIcon showIcon) {
        this.owner = owner;
        this.showIcon = showIcon;
        this.componentStatus = new HashMap<JComponent, Errorable.Status>(23);
    }

    public void addComponent(final NumberField field) {
        field.getDocument().addDocumentListener((DocumentListener)new DocumentUpdateListener(){

            public void update() {
                SimpleSwingFormValidation.this.componentStatus.put(field, SimpleSwingFormValidation.this.getStatus(field));
                SimpleSwingFormValidation.this.updateFormStatus();
            }
        });
    }

    private void updateFormStatus() {
        Errorable.Status status = Errorable.Status.OK;
        for (Errorable.Status each : this.componentStatus.values()) {
            switch (each) {
                case ERROR: {
                    this.showIcon.show(ViewImageResource.formError(), (Component)this.owner);
                    return;
                }
                case WARNING: {
                    status = Errorable.Status.WARNING;
                }
            }
        }
        if (status == Errorable.Status.OK) {
            this.showIcon.clearIcon((Component)this.owner);
        }
        if (status == Errorable.Status.WARNING) {
            this.showIcon.show(ViewImageResource.formError(), (Component)this.owner);
        }
    }

    private Errorable.Status getStatus(NumberField field) {
        return field.hasError() ? Errorable.Status.ERROR : (field.hasWarning() ? Errorable.Status.WARNING : Errorable.Status.OK);
    }
}

