/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.version;

import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyChangeListener;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import java.io.DataInput;
import java.io.IOException;
import java.util.Optional;

public class SafetyVersionValidator {
    public boolean isValidSafetyVersion(DataInput stream, ChecksumVersion polyscopeChecksumVersion) throws IOException {
        int controllerSafetyVersionMajor = stream.readUnsignedByte();
        int controllerSafetyVersionMinor = stream.readUnsignedByte();
        ChecksumVersion controllerChecksumVersion = this.getChecksumVersion(controllerSafetyVersionMajor, controllerSafetyVersionMinor);
        this.faultIfSafetyVersionsAreDifferent(polyscopeChecksumVersion, controllerChecksumVersion);
        return controllerChecksumVersion.equals((Object)polyscopeChecksumVersion);
    }

    private void faultIfSafetyVersionsAreDifferent(ChecksumVersion polyscopeChecksumVersion, ChecksumVersion controllerChecksumVersion) {
        if (!controllerChecksumVersion.equals((Object)polyscopeChecksumVersion)) {
            Log.error((String)("Safety Version from controller was: [" + controllerChecksumVersion + "], but expected Version: [" + polyscopeChecksumVersion + "]"));
            EventNotificationService.notify(SafetyChangeListener.class, SafetyChangeListener::safetyMismatchWithController);
        }
    }

    private ChecksumVersion getChecksumVersion(int major, int minor) {
        Optional controllerChecksumVersion = ChecksumVersion.fromMajorMinor((int)major, (int)minor);
        if (controllerChecksumVersion.isPresent()) {
            return (ChecksumVersion)controllerChecksumVersion.get();
        }
        Log.error((String)("Unknown Safety Version received from controller: [" + major + "." + minor + "]"));
        return ChecksumVersion.NULL;
    }
}

