/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.core;

import com.ur.lang.Defense;
import com.ur.math.NumberValue;
import com.ur.math.NumberValueUtils;

public class Range<T extends NumberValue> {
    private final T minimum;
    private final T maximum;

    public Range(T minimum, T maximum) {
        Defense.notNull(minimum);
        Defense.notNull(maximum);
        Defense.isCondition((boolean)NumberValueUtils.isLesserThanOrEqual(minimum, maximum), (String)"Minimum should be lesser than Maximum or equal");
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public T getMinimumValue() {
        return this.minimum;
    }

    public T getMaximumValue() {
        return this.maximum;
    }

    public boolean isWithinRange(T weight) {
        if (NumberValueUtils.isGreaterThan(this.minimum, weight)) {
            return false;
        }
        return !NumberValueUtils.isLesserThan(this.maximum, weight);
    }

    public int hashCode() {
        return this.minimum.hashCode() * 13 + this.maximum.hashCode() * 27;
    }

    public boolean equals(Object obj) {
        if (obj == null || !Range.class.equals(obj.getClass())) {
            return false;
        }
        Range other = (Range)obj;
        return this.minimum.equals(other.minimum) && this.maximum.equals(other.maximum);
    }

    public String toString() {
        return "Min: " + this.minimum + ", Max: " + this.maximum;
    }
}

