/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.core;

import com.ur.math.Angle;
import com.ur.monitor.model.Vector3;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SphericalUnitVector {
    public static final SphericalUnitVector Z_AXIS = new SphericalUnitVector(Angle.ZERO, Angle.ZERO);
    public final Angle inclination;
    public final Angle azimuth;
    private Vector3 derivedUnitVector = Vector3.ZERO;

    private SphericalUnitVector(Angle inclination, Angle azimuth) {
        this.inclination = inclination;
        this.azimuth = azimuth;
    }

    public Vector3 asVector3() {
        if (this.derivedUnitVector == Vector3.ZERO) {
            double inclinationSine = Math.sin(this.inclination.asDouble());
            double inclinationCosine = Math.cos(this.inclination.asDouble());
            double azimuthSine = Math.sin(this.azimuth.asDouble());
            double azimuthCosine = Math.cos(this.azimuth.asDouble());
            this.derivedUnitVector = new Vector3(azimuthCosine * inclinationSine, azimuthSine * inclinationSine, inclinationCosine);
        }
        return this.derivedUnitVector;
    }

    public SphericalUnitVector normalized() {
        Angle tiltAngleNormalized = this.inclination.normalized();
        Angle panAngleNormalized = this.azimuth.normalized();
        if (tiltAngleNormalized.isLargerThan(Angle.HALF_REVOLUTION)) {
            tiltAngleNormalized = Angle.WHOLE_REVOLUTION.minus(tiltAngleNormalized);
            panAngleNormalized = panAngleNormalized.plus(Angle.HALF_REVOLUTION).normalized();
        }
        if (tiltAngleNormalized == this.inclination && panAngleNormalized == this.azimuth) {
            return this;
        }
        return new SphericalUnitVector(tiltAngleNormalized, panAngleNormalized);
    }

    public boolean isEquivalentTo(SphericalUnitVector other) {
        return this.normalized().equals(other.normalized());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.inclination).append((Object)this.azimuth).toHashCode();
    }

    public boolean equals(Object other) {
        return other instanceof SphericalUnitVector && this.isEqualTo((SphericalUnitVector)other);
    }

    private boolean isEqualTo(SphericalUnitVector otherVector) {
        return new EqualsBuilder().append((Object)this.inclination, (Object)otherVector.inclination).append((Object)this.azimuth, (Object)otherVector.azimuth).isEquals();
    }

    public String toString() {
        return String.format("[%.1f\u00b0, %.1f\u00b0] (%s)", this.inclination.getIn(Angle.Unit.DEGREES), this.azimuth.getIn(Angle.Unit.DEGREES), this.asVector3().toString());
    }

    public static SphericalUnitVector fromDirection(Vector3 direction) {
        double azimuthInSI;
        double inclinationInSI = Math.acos(direction.z() / direction.length());
        double inclinationSine = Math.sin(inclinationInSI);
        if (inclinationSine == 0.0) {
            azimuthInSI = 0.0;
        } else {
            double azimuthSine = direction.y() / inclinationSine;
            double azimuthCosine = direction.x() / inclinationSine;
            azimuthInSI = Math.atan2(azimuthSine, azimuthCosine);
        }
        return SphericalUnitVector.fromSphericalCoordinates(inclinationInSI, azimuthInSI).normalized();
    }

    public static SphericalUnitVector fromSphericalCoordinates(double inclinationInSI, double azimuthInSI) {
        return new SphericalUnitVector(Angle.from((double)inclinationInSI, (Angle.Unit)Angle.Unit.SI), Angle.from((double)azimuthInSI, (Angle.Unit)Angle.Unit.SI));
    }

    public static SphericalUnitVector fromSphericalCoordinates(Angle inclination, Angle azimuth) {
        return new SphericalUnitVector(inclination, azimuth);
    }
}

