/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.core;

import com.ur.monitor.model.Sphere;
import com.ur.view.constants.safety.ToolSphere;
import java.util.Objects;
import java.util.UUID;

public class Workpiece {
    public final String name;
    public final UUID id;
    public final Sphere sphere;
    public final ToolSphere toolSphereDefinition;

    public Workpiece(String name, UUID id, Sphere sphere, ToolSphere toolSphereDefinition) {
        this.name = name;
        this.id = id;
        this.sphere = sphere;
        this.toolSphereDefinition = toolSphereDefinition;
    }

    public int getToolSphereDefinitionIntValue() {
        return this.toolSphereDefinition.getId();
    }

    public boolean isToolFlange() {
        return this.toolSphereDefinition == ToolSphere.DEFINED_AS_TOOL_FLANGE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workpiece workpiece = (Workpiece)o;
        if (!Objects.equals(this.name, workpiece.name)) {
            return false;
        }
        if (!Objects.equals(this.id, workpiece.id)) {
            return false;
        }
        if (!Objects.equals(this.toolSphereDefinition, workpiece.toolSphereDefinition)) {
            return false;
        }
        return Objects.equals(this.sphere, workpiece.sphere);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.sphere != null ? this.sphere.hashCode() : 0);
        return result;
    }
}

