/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.core;

import com.ur.bean.PropertyChangeSite;
import com.ur.bean.URPropertyChangeSupport;
import com.ur.math.Angle;
import com.ur.monitor.model.Sphere;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.safety.workpiece.core.SphericalUnitVector;
import com.ur.safety.workpiece.core.ToolOrientation;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceFactory;
import com.ur.view.constants.safety.ToolSphere;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class WorkpieceConfiguration
implements SafetySetupComponent,
PropertyChangeSite {
    public static final UUID TOOL_FLANGE_ID = UUID.fromString("058bafa6-fb2a-43e7-9f8f-268f9eb48afd");
    public static final UUID TOOL_DISABLED_ID = UUID.fromString("05cb2fa6-f92a-43e7-9f8f-268f9eb48afd");
    public static final Workpiece TOOL_FLANGE = WorkpieceFactory.buildToolFlangeWorkpiece();
    public static final Workpiece DISABLED_WORKPIECE = WorkpieceFactory.buildUndefinedWorkpiece();
    private static final String TOOL_ORIENTATION_PROPERTY = "toolOrientation";
    private final URPropertyChangeSupport changeSupport;
    private Workpiece[] workpieces = new Workpiece[]{TOOL_FLANGE, DISABLED_WORKPIECE, DISABLED_WORKPIECE};
    private ToolOrientation toolOrientation = new ToolOrientation(null, SphericalUnitVector.Z_AXIS);

    public WorkpieceConfiguration() {
        this.changeSupport = new URPropertyChangeSupport((Object)this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void fireEvent(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }

    public boolean isReducedModeDefined() {
        return false;
    }

    public int getNumberOfToolSpheres() {
        return this.workpieces.length;
    }

    public int getNumberOfToolSpheresForToolPositions() {
        return this.getToolSpheresForToolPositions().size();
    }

    public List<Sphere> getDefinedToolSpheres() {
        return Arrays.stream(this.workpieces).filter(it -> it.toolSphereDefinition != ToolSphere.UNDEFINED).map(it -> it.sphere).collect(Collectors.toList());
    }

    public List<Sphere> getToolSpheresForToolPositions() {
        return Arrays.stream(this.workpieces).filter(it -> it.toolSphereDefinition == ToolSphere.DEFINED).map(it -> it.sphere).collect(Collectors.toList());
    }

    public List<Sphere> getToolSpheres() {
        return Arrays.stream(this.workpieces).map(it -> it.sphere).collect(Collectors.toList());
    }

    public List<Workpiece> getWorkpieces() {
        return Arrays.asList(this.workpieces);
    }

    public void setWorkpieces(List<Workpiece> newWorkpieceList) {
        Workpiece[] oldValue = (Workpiece[])this.workpieces.clone();
        this.setToolSphereWorkpieces(newWorkpieceList);
        this.fireEvent(new PropertyChangeEvent(this, "workpieces", Arrays.asList(oldValue), newWorkpieceList));
    }

    public void setWorkpiecesFromBackend(List<Workpiece> newWorkpieceList) {
        Workpiece[] oldValue = (Workpiece[])this.workpieces.clone();
        if (this.hasToolFlangeBeenModified(newWorkpieceList) || this.hasNoToolFlangeToolFlange(newWorkpieceList)) {
            this.setToolSphereWorkpiecesWithModifiedToolFlange(newWorkpieceList);
            this.fireEvent(new PropertyChangeEvent(this, "workpieces", Arrays.asList(oldValue), newWorkpieceList));
        } else {
            this.setWorkpieces(newWorkpieceList);
        }
    }

    private boolean hasToolFlangeBeenModified(List<Workpiece> workpieceList) {
        return workpieceList.stream().filter(workpiece -> Objects.nonNull(workpiece.id) && TOOL_FLANGE_ID.toString().equals(workpiece.id.toString())).anyMatch(flange -> !flange.sphere.equals((Object)WorkpieceConfiguration.TOOL_FLANGE.sphere));
    }

    private boolean hasNoToolFlangeToolFlange(List<Workpiece> workpieceList) {
        return workpieceList.stream().noneMatch(workpiece -> Objects.nonNull(workpiece.id) && TOOL_FLANGE_ID.toString().equals(workpiece.id.toString()));
    }

    private void setToolSphereWorkpiecesWithModifiedToolFlange(List<Workpiece> newWorkpieceList) {
        Workpiece workpieceAtIndex2;
        Workpiece workpieceAtIndex1;
        Workpiece workpieceAtIndex0;
        this.workpieces[0] = workpieceAtIndex0 = this.getWorkpieceAtIndex(newWorkpieceList, 0);
        this.workpieces[1] = workpieceAtIndex1 = this.getWorkpieceAtIndex(newWorkpieceList, 1);
        this.workpieces[2] = workpieceAtIndex2 = this.getWorkpieceAtIndex(newWorkpieceList, 2);
    }

    private void setToolSphereWorkpieces(List<Workpiece> newWorkpieceList) {
        Workpiece workpieceAtIndex1;
        Workpiece workpieceAtIndex0;
        List<Workpiece> workpiecesWithoutToolFlange = newWorkpieceList.stream().filter(workpiece -> workpiece.toolSphereDefinition != ToolSphere.DEFINED_AS_TOOL_FLANGE).collect(Collectors.toList());
        this.workpieces[1] = workpieceAtIndex0 = this.getWorkpieceAtIndex(workpiecesWithoutToolFlange, 0);
        this.workpieces[2] = workpieceAtIndex1 = this.getWorkpieceAtIndex(workpiecesWithoutToolFlange, 1);
    }

    private Workpiece getWorkpieceAtIndex(List<Workpiece> newWorkpieceList, int index) {
        return newWorkpieceList.size() > index ? newWorkpieceList.get(index) : DISABLED_WORKPIECE;
    }

    public ToolOrientation getToolOrientation() {
        return this.toolOrientation;
    }

    public void updateToolOrientation(UUID tcpId, Angle polarAngle, Angle azimuthalAngle) {
        this.updateToolOrientation(tcpId, SphericalUnitVector.fromSphericalCoordinates(polarAngle, azimuthalAngle));
    }

    public void updateToolOrientation(UUID tcpId, SphericalUnitVector sphericalDirection) {
        ToolOrientation oldValue = this.toolOrientation;
        this.toolOrientation = new ToolOrientation(tcpId, sphericalDirection);
        this.fireEvent(new PropertyChangeEvent(this, TOOL_ORIENTATION_PROPERTY, oldValue, this.toolOrientation));
    }

    public boolean completelyEquals(Object other) {
        return this.equals(other);
    }

    public int hashCode() {
        HashCodeBuilder builder = new com.ur.lang.HashCodeBuilder(URMath.HASH_CODE_PRECISION).append((Object)this.getToolOrientation()).append(this.getNumberOfToolSpheres());
        this.getDefinedToolSpheres().forEach(toolSphere -> {
            HashCodeBuilder hashCodeBuilder2 = builder.append(toolSphere.toDoubleArray());
        });
        return builder.toHashCode();
    }

    public boolean equals(Object other) {
        if (Objects.nonNull(other) && other.getClass() == this.getClass()) {
            WorkpieceConfiguration otherConfiguration = (WorkpieceConfiguration)other;
            EqualsBuilder builder = new com.ur.lang.EqualsBuilder(1.0E-5).append((Object)this.getToolOrientation().sphericalDirection, (Object)otherConfiguration.getToolOrientation().sphericalDirection).append(this.getNumberOfToolSpheres(), otherConfiguration.getNumberOfToolSpheres());
            if (builder.isEquals()) {
                List<Sphere> spheres = this.getToolSpheres();
                List<Sphere> otherSpheres = otherConfiguration.getToolSpheres();
                builder.append(spheres.size(), otherSpheres.size());
                String spheresString = spheres.stream().map(Sphere::toString).collect(Collectors.joining(", "));
                String otherSpheresString = otherSpheres.stream().map(Sphere::toString).collect(Collectors.joining(", "));
                builder.append((Object)spheresString, (Object)otherSpheresString);
            }
            return builder.isEquals();
        }
        return false;
    }
}

