/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.core;

import com.ur.monitor.model.Sphere;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.view.constants.safety.ToolSphere;
import java.util.Arrays;
import java.util.UUID;

public class WorkpieceFactory {
    WorkpieceFactory() {
    }

    public static Workpiece buildWorkpieceFromToolSphereDefinition(int definition, Sphere sphere) {
        ToolSphere toolSphereDefinition = WorkpieceFactory.getToolSphereDefinitionFromIntValue(definition);
        if (toolSphereDefinition == ToolSphere.DEFINED_AS_TOOL_FLANGE) {
            return WorkpieceFactory.buildToolFlangeWorkpiece(sphere);
        }
        if (toolSphereDefinition == ToolSphere.DEFINED) {
            return WorkpieceFactory.buildDefinedWorkpiece(sphere, null);
        }
        return WorkpieceFactory.buildUndefinedWorkpiece();
    }

    public static Workpiece buildWorkpieceFromToolSphereDefinitionWithIdAndName(int definition, Sphere sphere, UUID id, String name) {
        ToolSphere toolSphereDefinition = WorkpieceFactory.getToolSphereDefinitionFromIntValue(definition);
        return new Workpiece(name, id, sphere, toolSphereDefinition);
    }

    public static Workpiece buildWorkpieceFromToolSphereDefinitionEnumWithIdAndName(ToolSphere toolSphereDefinition, Sphere sphere, UUID id, String name) {
        return new Workpiece(name, id, sphere, toolSphereDefinition);
    }

    public static Workpiece buildToolFlangeWorkpiece() {
        return new Workpiece(null, WorkpieceConfiguration.TOOL_FLANGE_ID, Sphere.ORIGIN, ToolSphere.DEFINED_AS_TOOL_FLANGE);
    }

    public static Workpiece buildToolFlangeWorkpiece(Sphere sphere) {
        return new Workpiece(null, WorkpieceConfiguration.TOOL_FLANGE_ID, sphere, ToolSphere.DEFINED_AS_TOOL_FLANGE);
    }

    public static Workpiece buildDefinedWorkpiece(Sphere sphere, UUID id) {
        return new Workpiece(null, id, sphere, ToolSphere.DEFINED);
    }

    public static Workpiece buildUndefinedWorkpiece() {
        return new Workpiece("DISABLED", WorkpieceConfiguration.TOOL_DISABLED_ID, Sphere.ORIGIN, ToolSphere.UNDEFINED);
    }

    private static ToolSphere getToolSphereDefinitionFromIntValue(int definition) {
        return Arrays.stream(ToolSphere.values()).filter(tool -> tool.getId() == definition).findFirst().orElse(ToolSphere.UNDEFINED);
    }
}

