/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.monitor.model.Vector3;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.AbstractSafetySetupToHtmlRenderer;
import com.ur.safety.HTMLPage;
import com.ur.safety.SafetySetupPanesLookAndFeel;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.util.domain.AlternatingBackgroundRowGenerator;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.util.swing.HTML;
import java.util.ArrayList;
import javax.inject.Inject;

public class ToolDefinitionToHtmlRenderer
extends AbstractSafetySetupToHtmlRenderer {
    @Inject
    public ToolDefinitionToHtmlRenderer(SafetyTextResource text, SafetySetupPanesLookAndFeel lookAndFeel) {
        super(text, lookAndFeel);
    }

    @Override
    public HTMLPage createContributedPage(SafetySetup safetySetup, boolean useSIUnits) {
        return new HTMLPage(this.textResource.toolPosition(), HTML.center((String)this.presentWorkpieceAsHTML((WorkpieceConfiguration)safetySetup.getComponent(WorkpieceConfiguration.class), useSIUnits)));
    }

    private String presentWorkpieceAsHTML(WorkpieceConfiguration component, boolean isSI) {
        ArrayList<String> sphereTableRows = new ArrayList<String>();
        UnitsConverter lengthUnit = isSI ? UnitsConverter.NULL_CONVERTER : Units.getMetersConverter();
        ValueConverter converter = UnitsValueConverterFactory.getLengthConverter((boolean)isSI);
        sphereTableRows.add(HTML.tableRow((String[])new String[]{HTML.tableHeaderWithProperties((String)"align=left", (String)this.textResource.tool()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.textResource.center()), HTML.tableHeaderWithProperties((String)"align=center colspan=2", (String)this.textResource.radius())}));
        AlternatingBackgroundRowGenerator rowGenerator = new AlternatingBackgroundRowGenerator();
        for (Workpiece workpiece : component.getWorkpieces()) {
            String name = workpiece.name;
            if (name == null) {
                name = this.textResource.origin();
            } else if (workpiece == WorkpieceConfiguration.DISABLED_WORKPIECE) {
                name = this.textResource.DISABLED();
            }
            Vector3 center = workpiece.sphere.center;
            sphereTableRows.add(rowGenerator.generate(HTML.tableCell((String)name), HTML.tableCellNumber((String)("[" + converter.getFormat().format(lengthUnit.convertFrom(center.x())) + ",&nbsp;" + converter.getFormat().format(lengthUnit.convertFrom(center.y())) + ",&nbsp;" + converter.getFormat().format(lengthUnit.convertFrom(center.z())) + "]")), HTML.tableCell((String)converter.getUnit()), HTML.tableCellNumber((String)((String)converter.fromModel((Object)workpiece.sphere.radius))), HTML.tableCell((String)converter.getUnit())));
        }
        return HTML.table((int)this.lookAndFeel.panelWidth, sphereTableRows);
    }
}

