/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.lang.EqualsUtil;
import com.ur.math.Length;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Sphere;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.tcp.TCP;
import com.ur.safety.util.infrastructure.SelectTCP;
import com.ur.safety.workpiece.core.Workpiece;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class UIWorkpiece {
    public static final UIWorkpiece NULL_WORKPIECE = new UIWorkpiece("", SelectTCP.Definition.ORIGIN, null, Sphere.ORIGIN, null);
    private final UUID id;
    private SelectTCP.Definition definition;
    private String name;
    private TCP tcp;
    private Sphere sphere;

    private UIWorkpiece(String name, SelectTCP.Definition definition, TCP tcp, Sphere sphere, UUID id) {
        this.name = name;
        this.definition = definition;
        this.tcp = tcp;
        this.sphere = sphere;
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVisible() {
        return true;
    }

    public void setDefault() {
        this.definition = SelectTCP.Definition.ORIGIN;
        this.tcp = null;
        this.sphere = Sphere.ORIGIN;
    }

    public SelectTCP.Definition getDefinition() {
        return this.definition;
    }

    public TCP getTcp() {
        return this.tcp;
    }

    public void setTCP(TCP tcp) {
        this.definition = SelectTCP.Definition.FROM_TCP;
        this.tcp = tcp;
        this.sphere = new Sphere(new Pose6d(tcp.getOffsetPose().asArray()).getPosition(), this.sphere.radius);
    }

    public Sphere getSphere() {
        return this.sphere;
    }

    public void setSphereCenter(double x, double y, double z) {
        this.sphere = new Sphere(new Vector3(x, y, z), this.sphere.radius);
        this.definition = this.sphere == Sphere.ORIGIN ? SelectTCP.Definition.ORIGIN : SelectTCP.Definition.CUSTOM;
        this.tcp = null;
    }

    public void setSphereRadius(Length radius) {
        this.sphere = new Sphere(this.sphere.center, radius);
    }

    public static List<UIWorkpiece> transform(List<Workpiece> workpieces, TCPSettings settings, String nullName) {
        ArrayList<UIWorkpiece> result = new ArrayList<UIWorkpiece>();
        for (Workpiece each : workpieces) {
            result.add(UIWorkpiece.transform(each, settings, nullName));
        }
        return result;
    }

    public static UIWorkpiece transform(Workpiece each, TCPSettings settings, String nullName) {
        TCP tcp = settings.getTCPByUUID(each.id);
        if (tcp != null) {
            return new UIWorkpiece(UIWorkpiece.nullToEmpty(each.name, nullName), SelectTCP.Definition.FROM_TCP, tcp, each.sphere, each.id);
        }
        if (EqualsUtil.equals((Object)each.sphere.center, (Object)Vector3.ZERO)) {
            return new UIWorkpiece(UIWorkpiece.nullToEmpty(each.name, nullName), SelectTCP.Definition.ORIGIN, null, each.sphere, each.id);
        }
        return new UIWorkpiece(UIWorkpiece.nullToEmpty(each.name, nullName), SelectTCP.Definition.CUSTOM, null, each.sphere, each.id);
    }

    private static String nullToEmpty(String name, String nullName) {
        return name == null ? nullName : name;
    }
}

