/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.lang.EndianConverter;
import com.ur.math.Length;
import com.ur.monitor.model.Sphere;
import com.ur.safety.checksum.impl.SafetyChecksumGenerator_1_0;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import java.nio.ByteBuffer;

public class WorkpieceChecksumContribution
implements SafetyChecksumGenerator_1_0.ChecksumGeneratorContribution<WorkpieceConfiguration> {
    private static final int PACKAGE_SIZE = 57;
    private static final int NUMBER_OF_TCP_SPHERES = 3;

    @Override
    public Class<WorkpieceConfiguration> getComponentType() {
        return WorkpieceConfiguration.class;
    }

    @Override
    public int getByteCount() {
        return 57;
    }

    @Override
    public void addBytes(EndianConverter converter, ByteBuffer buffer, WorkpieceConfiguration component) {
        buffer.put((byte)component.getToolSpheres().size());
        int i = 0;
        while (i < 3) {
            Sphere sphere = Sphere.ORIGIN;
            if (i < component.getToolSpheres().size()) {
                sphere = component.getToolSpheres().get(i);
            }
            converter.convert(buffer, (float)sphere.center.x());
            converter.convert(buffer, (float)sphere.center.y());
            converter.convert(buffer, (float)sphere.center.z());
            converter.convert(buffer, (float)sphere.radius.getIn(Length.Unit.SI));
            ++i;
        }
        converter.convert(buffer, component.getToolOrientation().sphericalDirection.inclination.asFloat());
        converter.convert(buffer, component.getToolOrientation().sphericalDirection.azimuth.asFloat());
    }
}

