/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.lang.EndianConverter;
import com.ur.math.Length;
import com.ur.monitor.model.Sphere;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.safety.workpiece.domain.WorkpieceChecksumContribution;
import java.nio.ByteBuffer;

public class WorkpieceChecksumContribution_5_7
extends WorkpieceChecksumContribution {
    private static final int NUMBER_OF_TOOL_SPHERES = 1;
    private static final int THREE_SPHERES_OF_FOUR_BYTES_PLUS_DEFINITION = 51;
    private static final int INCLINATION_AND_AZIMUT = 8;
    private static final int PACKAGE_SIZE = 60;

    @Override
    public Class<WorkpieceConfiguration> getComponentType() {
        return WorkpieceConfiguration.class;
    }

    @Override
    public int getByteCount() {
        return 60;
    }

    @Override
    public void addBytes(EndianConverter converter, ByteBuffer buffer, WorkpieceConfiguration component) {
        buffer.put((byte)component.getNumberOfToolSpheres());
        component.getWorkpieces().forEach(workpiece -> this.writeWorkpieceToBuffer(converter, buffer, (Workpiece)workpiece));
        converter.convert(buffer, component.getToolOrientation().sphericalDirection.inclination.asFloat());
        converter.convert(buffer, component.getToolOrientation().sphericalDirection.azimuth.asFloat());
    }

    private void writeWorkpieceToBuffer(EndianConverter converter, ByteBuffer buffer, Workpiece workpiece) {
        Sphere sphere = workpiece.sphere;
        converter.convert(buffer, (float)sphere.center.x());
        converter.convert(buffer, (float)sphere.center.y());
        converter.convert(buffer, (float)sphere.center.z());
        converter.convert(buffer, (float)sphere.radius.getIn(Length.Unit.SI));
        buffer.put((byte)workpiece.getToolSphereDefinitionIntValue());
    }
}

