/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.lang.StringUtils;
import com.ur.math.Angle;
import com.ur.math.Length;
import com.ur.monitor.model.Sphere;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.installation.SafetySetupConverter;
import com.ur.safety.workpiece.core.SphericalUnitVector;
import com.ur.safety.workpiece.core.ToolOrientation;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.safety.workpiece.core.WorkpieceFactory;
import com.ur.view.constants.safety.ToolSphere;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class WorkpieceContribution
implements SafetySetupContribution<WorkpieceConfiguration>,
SafetySetupConverter<WorkpieceConfiguration> {
    static final String WORKPIECE_CONFIGURATION_SECTION = "WorkpieceConfiguration";
    static final String TOOL_SPHERES_KEY = "toolSpheres";
    private static final String TOOL_SPHERE_NAMES_KEY = "toolSphereNames";
    private static final String TOOL_SPHERE_IDS_KEY = "toolSphereIDs";
    private static final String TOOL_DIRECTION_ID_KEY = "toolDirectionID";
    private static final String TOOL_DIRECTION_INCLINATION_KEY = "toolDirectionInclination";
    private static final String TOOL_DIRECTION_AZIMUTH_KEY = "toolDirectionAzimuth";
    private static final List<Workpiece> WORKPIECE_DEFAULT = Arrays.asList(WorkpieceConfiguration.TOOL_FLANGE, WorkpieceConfiguration.DISABLED_WORKPIECE, WorkpieceConfiguration.DISABLED_WORKPIECE);
    private static final Angle TOOL_DIRECTION_INCLINATION_DEFAULT = Angle.ZERO;
    private static final Angle TOOL_DIRECTION_AZIMUTH_DEFAULT = Angle.ZERO;

    @Override
    public Class<WorkpieceConfiguration> getComponentType() {
        return WorkpieceConfiguration.class;
    }

    public WorkpieceConfiguration createDefaultComponent() {
        WorkpieceConfiguration configuration = new WorkpieceConfiguration();
        this.setToDefaults(configuration);
        return configuration;
    }

    @Override
    public void convertToG5(WorkpieceConfiguration component) {
        this.setToDefaults(component);
    }

    @Override
    public List<String> getAffectedG3SafetyItems(WorkpieceConfiguration safetySetup, SafetyTextResource textResource) {
        return Collections.emptyList();
    }

    private void setToDefaults(WorkpieceConfiguration component) {
        component.setWorkpieces(WORKPIECE_DEFAULT);
        component.updateToolOrientation(null, SphericalUnitVector.Z_AXIS);
    }

    public WorkpieceConfiguration readFromOptions(ChecksumVersion checksumVersion, Options options) {
        WorkpieceConfiguration component = this.createDefaultComponent();
        OptionsSection section = options.getSection(WORKPIECE_CONFIGURATION_SECTION);
        String toolSpheresArray = section.getString(TOOL_SPHERES_KEY, null);
        String[] toolSphereNames = section.getStringArray(TOOL_SPHERE_NAMES_KEY, null);
        String[] toolSphereIDs = section.getStringArray(TOOL_SPHERE_IDS_KEY, null);
        List<Workpiece> workpieceList = this.getWorkpieceList(toolSpheresArray, toolSphereNames, toolSphereIDs);
        component.setWorkpiecesFromBackend(workpieceList);
        UUID tcpId = section.getUUID(TOOL_DIRECTION_ID_KEY, null);
        component.updateToolOrientation(tcpId, SphericalUnitVector.fromSphericalCoordinates(section.getDouble(TOOL_DIRECTION_INCLINATION_KEY, Double.valueOf(TOOL_DIRECTION_INCLINATION_DEFAULT.asDouble())), section.getDouble(TOOL_DIRECTION_AZIMUTH_KEY, Double.valueOf(TOOL_DIRECTION_AZIMUTH_DEFAULT.asDouble()))));
        return component;
    }

    private List<Workpiece> getWorkpieceList(String toolSpheresArray, String[] toolSphereNames, String[] toolSphereIDs) {
        if (StringUtils.isNullOrEmpty((String)toolSpheresArray)) {
            return new ArrayList<Workpiece>(WORKPIECE_DEFAULT);
        }
        String trimmedToolSpheresArray = this.trimLeadingAndTrailingBrackets(toolSpheresArray);
        String[] sphereStrings = this.splitToolSpheresArrayToWorkpieceStrings(trimmedToolSpheresArray);
        return IntStream.range(0, sphereStrings.length).mapToObj(index -> this.mapWorkpieceFromToolSphereArrays(index, sphereStrings, toolSphereNames, toolSphereIDs)).collect(Collectors.toList());
    }

    private String trimLeadingAndTrailingBrackets(String toolSpheresArray) {
        return toolSpheresArray.trim().replace("[[", "").replace("]]", "");
    }

    private String[] splitToolSpheresArrayToWorkpieceStrings(String trimmedToolSpheresArray) {
        return trimmedToolSpheresArray.split("], \\[");
    }

    private Workpiece mapWorkpieceFromToolSphereArrays(int index, String[] sphereStrings, String[] toolSphereNames, String[] toolSphereIDs) {
        UUID toolSphereID = StringUtils.isNullOrEmpty((String)toolSphereIDs[index]) ? null : UUID.fromString(toolSphereIDs[index]);
        String toolSphereName = toolSphereNames[index];
        String sphereString = sphereStrings[index];
        return this.parseWorkpieceFromString(sphereString, toolSphereName, toolSphereID, index);
    }

    private Workpiece parseWorkpieceFromString(String sphereString, String toolSphereName, UUID toolSphereID, int index) {
        String[] sphereValues = sphereString.replaceAll("\\s", "").split(",");
        double x = Double.parseDouble(sphereValues[0]);
        double y = Double.parseDouble(sphereValues[1]);
        double z = Double.parseDouble(sphereValues[2]);
        double radius = Double.parseDouble(sphereValues[3]);
        Sphere sphere = new Sphere(new Vector3(x, y, z), Length.from((double)radius, (Length.Unit)Length.Unit.SI));
        int definition = this.isToolSphereDefinitionIncluded(sphereValues) ? Integer.parseInt(sphereValues[4]) : this.getDefaultToolSphereDefinition(index, toolSphereID);
        return WorkpieceFactory.buildWorkpieceFromToolSphereDefinitionWithIdAndName(definition, sphere, toolSphereID, toolSphereName);
    }

    private boolean isToolSphereDefinitionIncluded(String[] sphereValues) {
        return sphereValues.length == 5;
    }

    private int getDefaultToolSphereDefinition(int index, UUID toolSphereID) {
        return index == 0 ? ToolSphere.DEFINED_AS_TOOL_FLANGE.getId() : this.getToolSphereDefinition(toolSphereID);
    }

    private int getToolSphereDefinition(UUID toolSphereID) {
        if (WorkpieceConfiguration.DISABLED_WORKPIECE.id.equals(toolSphereID)) {
            return ToolSphere.UNDEFINED.getId();
        }
        return ToolSphere.DEFINED.getId();
    }

    public void copyToOptions(ChecksumVersion checksumVersion, Options options, WorkpieceConfiguration component) {
        OptionsSection section = options.getSection(WORKPIECE_CONFIGURATION_SECTION);
        String[] toolSphereNames = new String[component.getNumberOfToolSpheres()];
        String[] toolSphereIDs = new String[component.getNumberOfToolSpheres()];
        int i = 0;
        while (i < component.getNumberOfToolSpheres()) {
            Workpiece each = component.getWorkpieces().get(i);
            toolSphereNames[i] = each.name;
            toolSphereIDs[i] = each.id == null ? null : each.id.toString();
            ++i;
        }
        section.setStringArray(TOOL_SPHERES_KEY, this.generateToolSpheresString(component.getWorkpieces(), checksumVersion));
        section.setStringArray(TOOL_SPHERE_NAMES_KEY, toolSphereNames);
        section.setStringArray(TOOL_SPHERE_IDS_KEY, toolSphereIDs);
        ToolOrientation toolOrientation = component.getToolOrientation();
        section.setUUID(TOOL_DIRECTION_ID_KEY, toolOrientation.sourceTCPId);
        section.setDouble(TOOL_DIRECTION_INCLINATION_KEY, Double.valueOf(toolOrientation.sphericalDirection.inclination.asDouble()));
        section.setDouble(TOOL_DIRECTION_AZIMUTH_KEY, Double.valueOf(toolOrientation.sphericalDirection.azimuth.asDouble()));
    }

    public void copyControllerRepresentationTo(ChecksumVersion checksumVersion, Options options, WorkpieceConfiguration component) {
        OptionsSection section = options.getSection(WORKPIECE_CONFIGURATION_SECTION);
        section.setStringArray(TOOL_SPHERES_KEY, this.generateToolSpheresString(component.getWorkpieces(), checksumVersion));
        ToolOrientation toolOrientation = component.getToolOrientation();
        section.setFloat(TOOL_DIRECTION_INCLINATION_KEY, Float.valueOf(toolOrientation.sphericalDirection.inclination.asFloat()));
        section.setFloat(TOOL_DIRECTION_AZIMUTH_KEY, Float.valueOf(toolOrientation.sphericalDirection.azimuth.asFloat()));
    }

    public boolean isSupported(ChecksumVersion version) {
        return true;
    }

    private String[] generateToolSpheresString(List<Workpiece> workpieceList, ChecksumVersion checksumVersion) {
        return (String[])workpieceList.stream().map(workpiece -> this.convertWorkpieceToToolSphereString((Workpiece)workpiece, checksumVersion)).toArray(String[]::new);
    }

    private String convertWorkpieceToToolSphereString(Workpiece workpiece, ChecksumVersion checksumVersion) {
        StringBuilder builder = new StringBuilder();
        String separator = ", ";
        float x = (float)workpiece.sphere.center.x();
        float y = (float)workpiece.sphere.center.y();
        float z = (float)workpiece.sphere.center.z();
        float radius = (float)workpiece.sphere.radius.getIn(Length.Unit.SI);
        int toolSphereDefinitionIntValue = workpiece.getToolSphereDefinitionIntValue();
        builder.append("[").append(x).append(separator).append(y).append(separator).append(z).append(separator).append(radius).append(this.isAtLeastSafetyVersion57(checksumVersion) ? separator : "").append(this.isAtLeastSafetyVersion57(checksumVersion) ? Integer.valueOf(toolSphereDefinitionIntValue) : "").append("]");
        return builder.toString();
    }

    private boolean isAtLeastSafetyVersion57(ChecksumVersion checksumVersion) {
        return checksumVersion.atLeast(ChecksumVersion.VERSION_5_7);
    }
}

