/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.monitor.model.Sphere;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.domain.SetInstallationValidator;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.swing.dialog.ErrorMessage;
import java.util.List;
import javax.inject.Inject;

public class WorkpieceInstallationValidator
implements SetInstallationValidator {
    private final SafetyTextResource safetyTextResource;

    @Inject
    public WorkpieceInstallationValidator(SafetyTextResource safetyTextResource) {
        this.safetyTextResource = safetyTextResource;
    }

    public SetInstallationValidator.Validity validate(Installation installation) {
        SafetySetup safetySetup = (SafetySetup)installation.getComponent(SafetySetup.class);
        WorkpieceConfiguration workpieceConfiguration = (WorkpieceConfiguration)safetySetup.getComponent(WorkpieceConfiguration.class);
        List<Workpiece> workpieces = workpieceConfiguration.getWorkpieces();
        boolean isMissingWorkpieceAtToolFlange = workpieces.stream().noneMatch(workpiece -> Sphere.ORIGIN.equals((Object)workpiece.sphere));
        if (isMissingWorkpieceAtToolFlange) {
            return SetInstallationValidator.Validity.ERROR;
        }
        return SetInstallationValidator.Validity.VALID;
    }

    public ErrorMessage getErrorMessage(Installation installation) {
        return new ErrorMessage(this.safetyTextResource.errorNoToolFlangeDefinedInInstallationTitle(), this.safetyTextResource.errorNoToolFlangeDefinedInInstallationExplanation());
    }
}

