/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.lang.Defense;
import com.ur.monitor.model.Sphere;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.safety.workpiece.core.WorkpieceFactory;
import com.ur.util.CollectionUtils;
import com.ur.view.constants.safety.ToolSphere;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;

public class WorkpieceLookup {
    private final InstallationComponentLookup lookupService;

    @Inject
    WorkpieceLookup(InstallationComponentLookup lookupService) {
        this.lookupService = lookupService;
    }

    public List<Workpiece> getWorkpieces() {
        return CollectionUtils.filter(this.getWorkpieceConfiguration().getWorkpieces(), workpiece -> workpiece.toolSphereDefinition != ToolSphere.UNDEFINED);
    }

    public void update(int index, String name, UUID uuid, Sphere sphere) {
        List<Workpiece> workpieces = this.getWorkpieces();
        Defense.isCondition((workpieces.size() > index ? 1 : 0) != 0, (String)"Index out of bounds");
        Workpiece newWorkpiece = WorkpieceFactory.buildWorkpieceFromToolSphereDefinitionEnumWithIdAndName(ToolSphere.DEFINED, sphere, uuid, name);
        if (this.isUpdatableWorkpieceAndNotEqualToExistingWorkpiece(newWorkpiece, workpieces.get(index))) {
            workpieces.remove(index);
            workpieces.add(index, newWorkpiece);
            WorkpieceConfiguration configuration = this.getWorkpieceConfiguration();
            configuration.setWorkpieces(workpieces);
        }
    }

    private boolean isUpdatableWorkpieceAndNotEqualToExistingWorkpiece(Workpiece newWorkpiece, Workpiece existingWorkpiece) {
        return !existingWorkpiece.isToolFlange() && !newWorkpiece.equals(existingWorkpiece);
    }

    public Workpiece createWorkpiece(String name) {
        List<Workpiece> workpieces = this.getWorkpieces();
        Defense.isCondition((workpieces.size() < 3 ? 1 : 0) != 0, (String)"Cannot add more than 3 workpieces");
        Workpiece result = WorkpieceFactory.buildWorkpieceFromToolSphereDefinitionEnumWithIdAndName(ToolSphere.DEFINED, Sphere.ORIGIN, UUID.randomUUID(), name);
        workpieces.add(result);
        WorkpieceConfiguration configuration = this.getWorkpieceConfiguration();
        configuration.setWorkpieces(new ArrayList<Workpiece>(workpieces));
        return result;
    }

    public void removeWorkpiece(int index) {
        List<Workpiece> workpieces = this.getWorkpieces();
        Defense.isCondition((workpieces.size() > index ? 1 : 0) != 0, (String)"Index out of bounds");
        workpieces.remove(index);
        WorkpieceConfiguration configuration = this.getWorkpieceConfiguration();
        configuration.setWorkpieces(workpieces);
    }

    public boolean isToolsDefined() {
        return this.getWorkpieceConfiguration().getNumberOfToolSpheresForToolPositions() > 0;
    }

    private WorkpieceConfiguration getWorkpieceConfiguration() {
        return (WorkpieceConfiguration)((SafetySetup)this.lookupService.getComponent(SafetySetup.class)).getComponent(WorkpieceConfiguration.class);
    }
}

