/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.domain;

import com.ur.lang.EndianConverter;
import com.ur.math.Length;
import com.ur.monitor.model.Sphere;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.safety.SafetyEndianConverter;
import com.ur.safety.controllerinterface.SkipParser;
import com.ur.safety.workpiece.core.SphericalUnitVector;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.safety.workpiece.core.WorkpieceFactory;
import com.ur.safety.workpiece.domain.WorkpieceParser;
import com.ur.view.constants.safety.ToolSphere;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class WorkpieceParserImpl
extends WorkpieceParser {
    private final SkipParser parserToSkipNumberOfSpheres = new SkipParser(1);
    private final EndianConverter endianConverter;

    @Inject
    WorkpieceParserImpl(SafetyEndianConverter safetyEndianConverter) {
        this.endianConverter = safetyEndianConverter.getConverter();
    }

    @Override
    public void parse(DataInput stream, ChecksumVersion version) throws IOException {
        this.workpieceConfiguration = new WorkpieceConfiguration();
        this.parserToSkipNumberOfSpheres.parse(stream, version);
        List<Workpiece> workpieceList = this.readTcpSpheres(stream, version);
        this.workpieceConfiguration.setWorkpiecesFromBackend(workpieceList);
        this.workpieceConfiguration.updateToolOrientation(null, SphericalUnitVector.fromSphericalCoordinates(this.endianConverter.convert(stream), this.endianConverter.convert(stream)));
    }

    private List<Workpiece> readTcpSpheres(DataInput stream, ChecksumVersion version) throws IOException {
        int numberOfSpheresInMessage = 3;
        ArrayList<Workpiece> workpieceList = new ArrayList<Workpiece>();
        int i = 0;
        while (i < numberOfSpheresInMessage) {
            Workpiece workpiece = this.getSphereAndDefinitionFromStream(stream, version, i);
            workpieceList.add(workpiece);
            ++i;
        }
        return workpieceList;
    }

    private Workpiece getSphereAndDefinitionFromStream(DataInput stream, ChecksumVersion version, int index) throws IOException {
        double x = this.endianConverter.convert(stream);
        double y = this.endianConverter.convert(stream);
        double z = this.endianConverter.convert(stream);
        double radius = this.endianConverter.convert(stream);
        Sphere sphere = new Sphere(new Vector3(x, y, z), Length.from((double)radius, (Length.Unit)Length.Unit.SI));
        int toolDefinition = this.getToolDefinition(stream, version, sphere, index);
        return WorkpieceFactory.buildWorkpieceFromToolSphereDefinition(toolDefinition, sphere);
    }

    private int getToolDefinition(DataInput stream, ChecksumVersion version, Sphere sphere, int index) throws IOException {
        if (version.atLeast(ChecksumVersion.VERSION_5_7)) {
            return stream.readUnsignedByte();
        }
        if (this.isToolFlange(index)) {
            return ToolSphere.DEFINED_AS_TOOL_FLANGE.getId();
        }
        if (this.isToolSphereWithDefaultValues(sphere)) {
            return ToolSphere.UNDEFINED.getId();
        }
        return ToolSphere.DEFINED.getId();
    }

    private boolean isToolFlange(int index) {
        return index == 0;
    }

    private boolean isToolSphereWithDefaultValues(Sphere sphere) {
        return WorkpieceConfiguration.DISABLED_WORKPIECE.sphere.equals((Object)sphere);
    }
}

