/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.externalapi;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.valueobjects.converters.UnitType;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.util.externalapi.CoordinateInputs;
import com.ur.safety.workpiece.externalapi.PositionCoordinates;
import com.ur.safety.workpiece.externalapi.WorkpieceInputBinder;
import com.ur.swing.InputView;
import com.ur.swing.number.Mode;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import java.text.Format;
import javax.inject.Inject;

public class WorkpieceInputBinderImpl
implements WorkpieceInputBinder {
    private final SafetyTextResource textResource;

    @Inject
    public WorkpieceInputBinderImpl(SafetyTextResource textResource) {
        this.textResource = textResource;
    }

    @Override
    public int getLabelWidth() {
        return 40;
    }

    @Override
    public int getUnitWidth() {
        return 190 - this.getLabelWidth();
    }

    @Override
    public String getLabelText(PositionCoordinates key) {
        return key.name();
    }

    @Override
    public void bindCoordinates(CoordinateInputs<PositionCoordinates> inputs) {
        InputView x = inputs.getInput(PositionCoordinates.X);
        InputView y = inputs.getInput(PositionCoordinates.Y);
        InputView z = inputs.getInput(PositionCoordinates.Z);
        x.setConverter(Units.getMetersConverter());
        y.setConverter(Units.getMetersConverter());
        z.setConverter(Units.getMetersConverter());
        new RangeValidationStrategy(this.textResource, -0.5, 0.5, x, y, z);
    }

    @Override
    public void bindWorkpieceRadiusSupport(InputView radius) {
        new RangeValidationStrategy(this.textResource, 0.0, 0.3, radius);
    }

    private static class RangeValidationStrategy {
        RangeValidationStrategy(SafetyTextResource text, double min, double max, InputView ... inputViews) {
            UnitsConverter converter = Units.getMetersConverter();
            InputView[] inputViewArray = inputViews;
            int n = inputViews.length;
            int n2 = 0;
            while (n2 < n) {
                InputView each = inputViewArray[n2];
                this.bindCoordinate(min, max, each, converter);
                String limits = null;
                limits = Settings.getUnits().isUS() ? text.minimumAndMaximumValuesTo3Decimals(converter.convertFrom(min), converter.convertFrom(max), converter.getUnit()) : text.minimumAndMaximumValues(converter.convertFrom(min), converter.convertFrom(max), converter.getUnit());
                each.setRestrictionsText(limits);
                ++n2;
            }
        }

        private void bindCoordinate(double min, double max, InputView inputView, UnitsConverter converter) {
            if (min < 0.0) {
                inputView.setMode(Mode.Standard);
                inputView.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)min, (double)max, (UnitsConverter)converter)});
            } else {
                inputView.setMode(Mode.PositiveNumbers);
                inputView.setErrorValidationStrategy(new ValidationStrategy[]{new ValidationStrategy.Composite(new ValidationStrategy[]{ValidationFactory.getPositiveNumberValidator(), ValidationFactory.getRangeValidator((double)min, (double)max, (UnitsConverter)converter)})});
            }
            if (Settings.getUnits() == UnitType.METRIC) {
                inputView.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0"));
                inputView.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)1)});
            } else {
                inputView.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.000"));
                inputView.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getDecimalPlacesValidator((int)3)});
            }
        }
    }
}

