/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.externalapi;

import com.ur.lang.EqualsUtil;
import com.ur.lang.NamingUtils;
import com.ur.lang.PrimitiveUtils;
import com.ur.math.Length;
import com.ur.monitor.model.Pose6d;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.internaltcp.core.HasUUID;
import com.ur.polyscope.internaltcp.domain.TCPSettings;
import com.ur.polyscope.tcp.TCP;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.impl.ReloadOnSafetyLoaded;
import com.ur.safety.security.SafetyLock;
import com.ur.safety.security.SafetyLockListener;
import com.ur.safety.util.externalapi.CoordinateValues;
import com.ur.safety.util.externalapi.SelectTCPPresenter;
import com.ur.safety.util.externalapi.SetCoordinatesPresenter;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.safety.workpiece.domain.UIWorkpiece;
import com.ur.safety.workpiece.domain.WorkpieceLookup;
import com.ur.safety.workpiece.externalapi.PositionCoordinates;
import com.ur.safety.workpiece.externalapi.WorkpieceView;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WorkpiecePresenter
implements ReloadOnSafetyLoaded,
SelectTCPPresenter,
SetCoordinatesPresenter<PositionCoordinates> {
    private final WorkpieceLookup lookup;
    private final InstallationComponentLookup installationLookupService;
    private final EnableWorkpieceView enablement;
    private final SafetyTextResource text;
    private WorkpieceView view;
    private UIWorkpiece activeWorkpiece = UIWorkpiece.NULL_WORKPIECE;
    private List<UIWorkpiece> workpieces = new ArrayList<UIWorkpiece>();

    @Inject
    public WorkpiecePresenter(WorkpieceLookup lookup, InstallationComponentLookup installationLookupService, EnableWorkpieceView enablement, SafetyTextResource text) {
        this.lookup = lookup;
        this.installationLookupService = installationLookupService;
        this.enablement = enablement;
        this.text = text;
    }

    public void setView(WorkpieceView view) {
        this.view = view;
        this.enablement.setWorkpieceView(view);
        this.activate();
    }

    public void activate() {
        TCPSettings settings = (TCPSettings)this.installationLookupService.getComponent(TCPSettings.class);
        if (this.workpieces.isEmpty()) {
            this.workpieces = UIWorkpiece.transform(this.lookup.getWorkpieces(), settings, this.text.origin());
        }
        if (this.activeWorkpiece == UIWorkpiece.NULL_WORKPIECE) {
            this.activeWorkpiece = this.workpieces.get(0);
        }
        this.view.setWorkpieces(this.workpieces);
        this.view.setTCPList(settings.getAllTCPs());
        this.view.selectWorkpiece(this.activeWorkpiece);
        this.updateProperties(this.activeWorkpiece);
    }

    public void deactivate() {
    }

    public void setName(String name) {
        this.activeWorkpiece.setName(name);
        this.updateProperties(this.activeWorkpiece);
    }

    @Override
    public void selectTCP(TCP tcp) {
        this.activeWorkpiece.setTCP(tcp);
        this.updateProperties(this.activeWorkpiece);
    }

    @Override
    public void selectDefaultTCP() {
        this.activeWorkpiece.setDefault();
        this.updateProperties(this.activeWorkpiece);
    }

    @Override
    public void setCoordinates(CoordinateValues<PositionCoordinates> value) {
        this.activeWorkpiece.setSphereCenter(value.getValue(PositionCoordinates.X), value.getValue(PositionCoordinates.Y), value.getValue(PositionCoordinates.Z));
        this.updateProperties(this.activeWorkpiece);
    }

    @Override
    public void synchronizeTCP() {
        this.selectTCP(this.activeWorkpiece.getTcp());
    }

    public void selectWorkpiece(UIWorkpiece element) {
        this.activeWorkpiece = element;
        this.updateProperties(this.activeWorkpiece);
    }

    public void setRadius(Length radius) {
        this.activeWorkpiece.setSphereRadius(radius);
        this.updateProperties(this.activeWorkpiece);
    }

    public void addWorkpiece() {
        TCPSettings settings = (TCPSettings)this.installationLookupService.getComponent(TCPSettings.class);
        this.activeWorkpiece = UIWorkpiece.transform(this.lookup.createWorkpiece(this.makeNameUnique(NamingUtils.addNumberToEndOfString((String)this.text.defaultWorkpiece(), (int)1))), settings, this.text.origin());
        this.workpieces.add(this.activeWorkpiece);
        this.view.setWorkpieces(this.workpieces);
        this.updateProperties(this.activeWorkpiece);
    }

    private String makeNameUnique(String name) {
        int number = 1;
        while (!this.isNameUnique(name)) {
            name = NamingUtils.stripNumbersOffEndOfName((String)name);
            name = NamingUtils.truncateNameToSupportNumbering((String)name);
            name = NamingUtils.addNumberToEndOfString((String)name, (int)number);
            ++number;
        }
        return name;
    }

    private boolean isNameUnique(String s) {
        for (UIWorkpiece each : this.workpieces) {
            if (!EqualsUtil.equals((Object)each.getName(), (Object)s)) continue;
            return false;
        }
        return true;
    }

    public void deleteWorkpiece() {
        int index = this.workpieces.indexOf(this.activeWorkpiece);
        this.lookup.removeWorkpiece(index);
        this.workpieces.remove(index);
        if (this.workpieces.isEmpty()) {
            this.addWorkpiece();
            this.view.notifyDeletionOfLastWorkpiece();
        } else {
            this.activeWorkpiece = this.workpieces.get(PrimitiveUtils.between((int)(index - 1), (int)0, (int)(this.workpieces.size() - 1)));
            this.view.setWorkpieces(this.workpieces);
            this.updateProperties(this.activeWorkpiece);
        }
    }

    public boolean canDelete() {
        return this.workpieces.size() > 1 && this.workpieces.indexOf(this.activeWorkpiece) != 0;
    }

    public boolean canAddMore() {
        return this.workpieces.size() < 3;
    }

    @Override
    public void reset() {
        this.workpieces.clear();
        this.activeWorkpiece = UIWorkpiece.NULL_WORKPIECE;
        this.activate();
        this.deactivate();
    }

    private void updateProperties(UIWorkpiece activeWorkpiece) {
        Vector3 center = activeWorkpiece.getSphere().center;
        this.view.selectWorkpiece(activeWorkpiece);
        this.view.highlightSphere(this.workpieces.indexOf(activeWorkpiece));
        this.view.setWorkpieceName(activeWorkpiece.getName());
        this.view.setWorkpieceCenter(key -> {
            switch (key) {
                case X: {
                    return center.x();
                }
                case Y: {
                    return center.y();
                }
                case Z: {
                    return center.z();
                }
            }
            throw new IllegalArgumentException("Unknown position coordinate: " + (Object)key);
        });
        this.view.setWorkpieceRadius(activeWorkpiece.getSphere().radius);
        if (activeWorkpiece.getTcp() == null) {
            this.lookup.update(this.workpieces.indexOf(activeWorkpiece), activeWorkpiece.getName(), activeWorkpiece.getId(), activeWorkpiece.getSphere());
            this.view.selectTCP(activeWorkpiece.getDefinition());
        } else {
            this.lookup.update(this.workpieces.indexOf(activeWorkpiece), activeWorkpiece.getName(), ((HasUUID)activeWorkpiece.getTcp()).getId(), activeWorkpiece.getSphere());
            this.view.selectTCP(activeWorkpiece.getTcp());
        }
        this.enablement.setWorkpiece(activeWorkpiece);
        this.enablement.updateEnablement();
    }

    public int workpieceCount() {
        return this.workpieces.size();
    }

    @Singleton
    private static class EnableWorkpieceView
    implements SafetyLockListener {
        private final SafetyLock safetyLock;
        private WorkpieceView view;
        private UIWorkpiece workpiece = UIWorkpiece.NULL_WORKPIECE;

        @Inject
        private EnableWorkpieceView(SafetyLock safetyLock) {
            this.safetyLock = safetyLock;
            safetyLock.addSafetyLockListener(this);
        }

        void setWorkpieceView(WorkpieceView view) {
            this.view = view;
        }

        public void setWorkpiece(UIWorkpiece workpiece) {
            this.workpiece = workpiece;
            this.updateEnablement();
        }

        @Override
        public void doUnlock() {
            this.updateEnablement();
        }

        @Override
        public void doLock() {
            this.updateEnablement();
        }

        void updateEnablement() {
            boolean synchronizationPossible;
            boolean isUnlocked = !this.safetyLock.isLocked();
            this.view.enableWorkpieces(isUnlocked);
            if (this.isUnmodifiableToolFlangeElement()) {
                this.view.enableProperties(false);
            } else {
                this.view.enableProperties(isUnlocked && this.workpiece != UIWorkpiece.NULL_WORKPIECE);
            }
            boolean bl = synchronizationPossible = this.workpiece.getTcp() != null;
            if (synchronizationPossible) {
                Vector3 center = this.workpiece.getSphere().center;
                Vector3 tcpPosition = new Pose6d(this.workpiece.getTcp().getOffsetPose().asArray()).getPosition();
                synchronizationPossible = !EqualsUtil.equals((Object)center, (Object)tcpPosition);
            }
            this.view.setSynchronizationPossible(synchronizationPossible);
        }

        private boolean isUnmodifiableToolFlangeElement() {
            return WorkpieceConfiguration.TOOL_FLANGE_ID.equals(this.workpiece.getId());
        }
    }
}

