/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.infrastructure;

import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.WidgetFactory;
import com.ur.swing.text.TextHolder;
import com.ur.swing.text.TextPicker;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.ArrayUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public abstract class EditNameView
extends MouseAdapter {
    public static final String EDITNAME = "rename.EditNameView";
    private ValidationStrategy nameValidationStrategy;
    public final JPanel panel;
    private final JButton editNameButton;
    private final JLabel innerLabel;

    public EditNameView(WidgetFactory widgetFactory, ValidationStrategy nameValidationStrategy) {
        this.nameValidationStrategy = nameValidationStrategy;
        this.innerLabel = widgetFactory.createLabel("##rename##");
        this.innerLabel.addMouseListener(this);
        this.innerLabel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0), this.innerLabel.getBorder()));
        this.editNameButton = widgetFactory.createButton((Action)new AbstractActionDefinition(){
            {
                this.putValue("SmallIcon", ViewImageResource.rename());
                this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
                this.putValue("InternalName", EditNameView.EDITNAME);
            }

            public void actionPerformed(ActionEvent e) {
                EditNameView.this.mouseClicked(null);
            }
        });
        this.panel = widgetFactory.horizontalPanel(new JComponent[]{this.editNameButton, this.innerLabel});
    }

    public void setName(String name) {
        this.innerLabel.setText(name);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TextPicker picker = new TextPicker(new TextHolder(){

            public String getText() {
                return EditNameView.this.innerLabel.getText();
            }

            public void setText(String text) {
                EditNameView.this.updateName(text);
            }
        });
        picker.setValidationStrategy(this.nameValidationStrategy);
        int position = this.innerLabel.getLocationOnScreen().y + this.innerLabel.getHeight();
        picker.showInputPanelAt((JComponent)this.innerLabel, position);
    }

    protected abstract void updateName(String var1);

    public void setEnabled(boolean enabled) {
        this.editNameButton.setEnabled(enabled);
        if (enabled) {
            if (!ArrayUtils.contains((Object)this, (Object[])this.innerLabel.getMouseListeners())) {
                this.innerLabel.addMouseListener(this);
            }
        } else {
            this.innerLabel.removeMouseListener(this);
        }
    }
}

