/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.infrastructure;

import com.ur.swing.WidgetFactory;
import com.ur.util.swing.ActionableListCellRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public abstract class ListView<T>
extends MouseAdapter {
    public static final Object ADD_ELEMENT = new Object();
    final JList list;
    private final DefaultListModel model;
    private int selectedIndex = -1;
    private boolean enabledForEdit;
    private ActionableListCellRenderer renderer;

    public ListView(WidgetFactory widgetFactory, String name, ActionableListCellRenderer renderer) {
        this.renderer = renderer;
        this.list = widgetFactory.createList();
        this.list.setName(name);
        this.list.setCellRenderer(renderer);
        this.model = new DefaultListModel();
        this.list.setModel(this.model);
        this.list.addMouseListener(this);
        this.list.setSelectionMode(0);
    }

    public void setAvailableElements(Iterable<T> planes) {
        this.model.removeAllElements();
        for (T each : planes) {
            this.model.addElement(each);
        }
        this.showAddOption();
        this.selectedIndex = this.list.getSelectedIndex();
    }

    public void addElement(T element) {
        this.model.insertElementAt(element, this.model.getSize() - 1);
        this.list.setSelectedIndex(this.model.getSize() - 2);
        this.selectedIndex = this.model.getSize() - 2;
        this.showAddOption();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.model.isEmpty()) {
            return;
        }
        int index = this.list.locationToIndex(e.getPoint());
        Object selection = this.list.getModel().getElementAt(index);
        if (selection == ADD_ELEMENT) {
            this.addElement();
        } else if (this.selectedIndex != index) {
            Object selectPlane = selection;
            this.selectElement(selectPlane);
            this.selectedIndex = index;
            if (this.renderer.getAction(e.getPoint()) == ActionableListCellRenderer.Action.SHOW) {
                this.setVisible();
            }
        } else {
            Object selectElement = selection;
            switch (this.renderer.getAction(e.getPoint())) {
                case SHOW: {
                    this.setVisible();
                    break;
                }
                case DELETE: {
                    this.removeElement();
                    break;
                }
                case SELECT: {
                    this.selectedIndex = index;
                    this.selectElement(selectElement);
                }
            }
        }
    }

    public void setSelectedElement(T selectElement) {
        this.selectedIndex = this.model.indexOf(selectElement);
        this.list.setSelectedValue(selectElement, true);
    }

    public void setEnabled(boolean enabled) {
        this.enabledForEdit = enabled;
        this.showAddOption();
    }

    public boolean isEnabled() {
        return this.enabledForEdit;
    }

    protected abstract void addElement();

    protected abstract void removeElement();

    protected abstract void selectElement(T var1);

    protected abstract void setVisible();

    protected abstract boolean canAddMore();

    private void showAddOption() {
        if (this.enabledForEdit && this.canAddMore()) {
            if (!this.model.contains(ADD_ELEMENT)) {
                this.model.addElement(ADD_ELEMENT);
            }
        } else {
            this.model.removeElement(ADD_ELEMENT);
        }
    }

    public boolean isSelected(T plane) {
        return this.list.getSelectedValue() == plane;
    }
}

