/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.infrastructure;

import com.ur.lang.PrimitiveUtils;
import com.ur.resources.ViewImageResource;
import com.ur.swing.WidgetFactory;
import com.ur.util.swing.ActionableListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class ListViewCellRenderer<T>
extends JPanel
implements ActionableListCellRenderer {
    public static final Icon BLANK_ICON = ViewImageResource.safetyLimitModeDisabled();
    private static final Border border = BorderFactory.createEmptyBorder(2, 5, 2, 5);
    private final Object addElement;
    private final JLabel isVisible;
    private final JLabel name;
    private final JLabel deleteElement;

    @Inject
    public ListViewCellRenderer(Object addElement, WidgetFactory factory, ShowVisibilityToggle showVisibilityToggle) {
        this.addElement = addElement;
        this.name = factory.createLabel("Dummy");
        this.isVisible = factory.createLabel(ViewImageResource.safetyBoundaryVisible());
        this.deleteElement = factory.createLabel(ViewImageResource.delete());
        this.setLayout(new BoxLayout(this, 0));
        this.name.setBorder(border);
        this.isVisible.setBorder(border);
        this.deleteElement.setBorder(border);
        this.add(this.name);
        this.add(Box.createGlue());
        if (showVisibilityToggle == ShowVisibilityToggle.YES) {
            this.add(this.isVisible);
            this.add(Box.createHorizontalStrut(8));
        }
        this.add(this.deleteElement);
        this.add(Box.createHorizontalStrut(15));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.addElement == value) {
            this.name.setText(this.getAddElementText());
            this.name.setIcon(ViewImageResource.gtkAdd());
            this.isVisible.setIcon(BLANK_ICON);
            this.isVisible.setEnabled(true);
            this.deleteElement.setIcon(BLANK_ICON);
        } else {
            try {
                Object boundary = value;
                this.name.setText(this.getText(boundary));
                this.name.setIcon(null);
                this.isVisible.setIcon(ViewImageResource.safetyBoundaryVisible());
                this.isVisible.setEnabled(this.isVisible(boundary));
                this.deleteElement.setIcon(this.getDeleteOrReset(isSelected, boundary));
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Failed to cast: " + value, cce);
            }
        }
        if (isSelected) {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setBackground(Color.white);
        }
        return this;
    }

    public Icon getDeleteOrReset(boolean isSelected, T boundary) {
        if (this.canDelete(boundary) && isSelected && this.isEnabled()) {
            return this.showDeleteIcon() ? ViewImageResource.delete() : ViewImageResource.refreshSmall();
        }
        return BLANK_ICON;
    }

    protected abstract String getText(T var1);

    protected abstract boolean isVisible(T var1);

    protected abstract boolean canDelete(T var1);

    protected abstract String getAddElementText();

    public boolean showDeleteIcon() {
        return true;
    }

    public ActionableListCellRenderer.Action getAction(Point point) {
        if (this.isButton(this.isVisible, point)) {
            return ActionableListCellRenderer.Action.SHOW;
        }
        if (!this.isEnabled()) {
            return ActionableListCellRenderer.Action.SELECT;
        }
        if (this.isButton(this.deleteElement, point)) {
            return ActionableListCellRenderer.Action.DELETE;
        }
        return ActionableListCellRenderer.Action.SELECT;
    }

    private boolean isButton(JLabel button, Point point) {
        Point buttonPoint = new Point();
        button.getLocation(buttonPoint);
        return PrimitiveUtils.isWithinRange((double)point.getX(), (double)buttonPoint.getX(), (double)(buttonPoint.getX() + (double)button.getWidth()));
    }

    public static enum ShowVisibilityToggle {
        YES,
        NO;

    }
}

