/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.boundaries.core.SafetyBoundaries;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneProximitySource;
import com.ur.safety.boundaries.externalapi.BoundaryPlaneVisualizationStrategy;
import com.ur.safety.workpiece.infrastructure.ToolSphereVisualizer;
import com.ur.util.Optional;
import javax.inject.Inject;
import javax.media.j3d.Node;

public class ToolSphereProximityVisualizer
implements ElementsVisualizer {
    private final SafetySettingsLookupService safetyLookup;
    private final BoundaryPlaneVisualizationStrategy visualizationStrategy;
    private final ToolSphereVisualizer visualizer;

    @Inject
    public ToolSphereProximityVisualizer(SafetySettingsLookupService safetyLookup, BoundaryPlaneVisualizationStrategy visualizationStrategy, ToolSphereVisualizer visualizer) {
        this.safetyLookup = safetyLookup;
        this.visualizationStrategy = visualizationStrategy;
        this.visualizer = visualizer;
    }

    public Node getElementNode() {
        return this.visualizer.getElementNode();
    }

    public void initialize() {
        this.clearVisualization();
    }

    public void clearVisualization() {
        this.visualizer.setVisible(false);
    }

    public void displayProximity(Pose6d tcpPose) {
        Optional<SafetyBoundaries> safetyBoundaries = this.safetyLookup.getControllerComponent(SafetyBoundaries.class);
        if (safetyBoundaries.isPresent()) {
            Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
            BoundaryPlaneVisualizationStrategy.PlaneProximity proximity = this.visualizationStrategy.getLimitProximity((SafetyBoundaries)safetyBoundaries.get(), BoundaryPlaneProximitySource.TOOL, tcpPose, tcpOffset);
            switch (proximity) {
                case LIMIT_VIOLATED: 
                case CRITICALLY_CLOSE_TO_LIMIT: 
                case CLOSE_TO_LIMIT: 
                case SOMEWHAT_CLOSE_TO_LIMIT: {
                    Pose6d toolFlange = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)tcpPose, (Pose6d)tcpOffset, (Pose6d)new Pose6d());
                    this.visualizer.update(toolFlange);
                    this.visualizer.setVisible(true);
                    break;
                }
                default: {
                    this.visualizer.setVisible(false);
                    break;
                }
            }
        } else {
            this.visualizer.setVisible(false);
        }
    }
}

