/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.infrastructure;

import com.sun.j3d.utils.geometry.Sphere;
import com.ur.math.Length;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.Pose6d;
import com.ur.polyscope.safety.SafetySetup;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.panel.ElementsVisualizer;
import com.ur.polyscope.visualizer.utils.MaterialDB;
import com.ur.polyscope.visualizer.utils.SetVisibilityDecorator;
import com.ur.safety.SafetyChangeListener;
import com.ur.safety.SafetySettingsLookupService;
import com.ur.safety.workpiece.core.Workpiece;
import com.ur.safety.workpiece.core.WorkpieceConfiguration;
import com.ur.util.event.EventManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.inject.Inject;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ToolSphereVisualizer
implements ElementsVisualizer {
    public static final double MINIMUM_SPHERE_RADIUS = 0.01;
    public static final double POSE_CHANGE_TOLERANCE = 0.001;
    private final EventManager eventManager;
    private final SafetySettingsLookupService safetyLookup;
    private SetVisibilityDecorator visibilityDecorator;
    private BranchGroup sphereBranchGroup;
    private BranchGroup subSphereBranchGroup;
    private Appearance sphereAppearance;
    private Appearance highlightedSphereAppearance;
    private WorkpieceConfigurationListener listener;
    private Pose6d cachedOutputFlangePose = new Pose6d();
    private int highlighted = -1;

    @Inject
    private ToolSphereVisualizer(EventManager eventManager, SafetySettingsLookupService safetyLookup) {
        this.eventManager = eventManager;
        this.safetyLookup = safetyLookup;
    }

    public static Pose6d getOutputFlangePose(RobotState robotState) {
        return Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)robotState.tool, (Pose6d)robotState.tcpOffset, (Pose6d)new Pose6d());
    }

    public static Appearance getRegularToolSphereAppearance() {
        return ToolSphereVisualizer.getToolSphereAppearance(new Appearance(), 0.5f);
    }

    public static Appearance getHighlightedToolSphereAppearance() {
        return ToolSphereVisualizer.getToolSphereAppearance(new Appearance(), 0.2f);
    }

    private static Appearance getToolSphereAppearance(Appearance baseAppearance, float transparency) {
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(baseAppearance.getColoringAttributes());
        appearance.setLineAttributes(baseAppearance.getLineAttributes());
        appearance.setPointAttributes(baseAppearance.getPointAttributes());
        appearance.setPolygonAttributes(baseAppearance.getPolygonAttributes());
        appearance.setRenderingAttributes(baseAppearance.getRenderingAttributes());
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparencyMode(0);
        transparencyAttributes.setTransparency(transparency);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setMaterial(MaterialDB.get((MaterialDB.MaterialID)MaterialDB.MaterialID.BROWN_PLASTIC));
        appearance.setTexture(baseAppearance.getTexture());
        appearance.setTextureAttributes(baseAppearance.getTextureAttributes());
        appearance.setTexCoordGeneration(baseAppearance.getTexCoordGeneration());
        appearance.setTextureUnitState(baseAppearance.getTextureUnitState());
        return appearance;
    }

    public Node getElementNode() {
        if (this.isInitialized()) {
            this.visibilityDecorator.detach();
            return this.visibilityDecorator.getJ3DNode();
        }
        WorkpieceConfiguration configuration = (WorkpieceConfiguration)this.safetyLookup.getSafetySetup().getComponent(WorkpieceConfiguration.class);
        this.listener = new WorkpieceConfigurationListener(configuration);
        this.eventManager.addStrongListener(SafetyChangeListener.class, (Object)new SafetyChangeListener.Template(){

            @Override
            public void safetyLoaded(SafetySetup setup) {
                ToolSphereVisualizer.this.listener.setWorkpieceConfiguration((WorkpieceConfiguration)setup.getComponent(WorkpieceConfiguration.class));
                ToolSphereVisualizer.this.highlighted = -1;
            }
        });
        this.subSphereBranchGroup = new BranchGroup();
        this.sphereAppearance = ToolSphereVisualizer.getRegularToolSphereAppearance();
        this.highlightedSphereAppearance = ToolSphereVisualizer.getHighlightedToolSphereAppearance();
        this.sphereBranchGroup = new BranchGroup();
        this.sphereBranchGroup.setCapability(13);
        this.sphereBranchGroup.setCapability(14);
        this.visibilityDecorator = new SetVisibilityDecorator(new Node[]{this.sphereBranchGroup});
        this.updateToolSpheres();
        return this.visibilityDecorator.getJ3DNode();
    }

    public void setVisible(boolean visible) {
        if (!this.isInitialized()) {
            return;
        }
        this.visibilityDecorator.setVisible(visible);
    }

    public void highlight(int index) {
        this.highlighted = index;
        this.updateToolSpheres();
    }

    private void updateToolSpheres() {
        this.updateToolSpheres(ToolSphereVisualizer.getOutputFlangePose(RobotState.getLatestRobotState()));
    }

    private void updateToolSpheres(Pose6d toolFlangePose) {
        if (!this.isInitialized()) {
            return;
        }
        WorkpieceConfiguration workpieceConfiguration = (WorkpieceConfiguration)this.safetyLookup.getSafetySetup().getComponent(WorkpieceConfiguration.class);
        List<Workpiece> workpieces = workpieceConfiguration.getWorkpieces();
        this.subSphereBranchGroup.detach();
        this.subSphereBranchGroup = new BranchGroup();
        this.subSphereBranchGroup.setCapability(17);
        this.cachedOutputFlangePose = toolFlangePose;
        for (Workpiece each : workpieces) {
            Point3d offset = new Point3d();
            if (Double.isNaN(each.sphere.center.x()) || Double.isNaN(each.sphere.center.y()) || Double.isNaN(each.sphere.center.z())) {
                offset.x = 0.0;
                offset.y = 0.0;
                offset.z = 0.0;
            } else {
                offset.x = each.sphere.center.x();
                offset.y = each.sphere.center.y();
                offset.z = each.sphere.center.z();
            }
            TransformGroup individualSphereTransformGroup = new TransformGroup();
            if (workpieces.indexOf(each) == this.highlighted) {
                individualSphereTransformGroup.addChild((Node)new Sphere((float)Math.max(0.01, each.sphere.radius.getIn(Length.Unit.SI)), this.highlightedSphereAppearance));
            } else {
                individualSphereTransformGroup.addChild((Node)new Sphere((float)Math.max(0.01, each.sphere.radius.getIn(Length.Unit.SI)), this.sphereAppearance));
            }
            Transform3D individualSphereTransformation = Pose6dTransformUtils.getTransform3D((Pose6d)this.cachedOutputFlangePose);
            individualSphereTransformation.transform(offset);
            individualSphereTransformation.setTranslation(new Vector3d((Tuple3d)offset));
            individualSphereTransformGroup.setTransform(individualSphereTransformation);
            this.subSphereBranchGroup.addChild((Node)individualSphereTransformGroup);
        }
        this.sphereBranchGroup.addChild((Node)this.subSphereBranchGroup);
    }

    public void update(Pose6d toolFlangePose6d) {
        RobotState robotState = RobotState.getLatestRobotState();
        this.setVisible(robotState.hasReceivedPositionData);
        if (!toolFlangePose6d.epsilonEquals(this.cachedOutputFlangePose, 0.001)) {
            this.updateToolSpheres(toolFlangePose6d);
            this.cachedOutputFlangePose.set(toolFlangePose6d);
        }
    }

    private boolean isInitialized() {
        return this.visibilityDecorator != null;
    }

    public void initialize() {
    }

    public void clearVisualization() {
        this.setVisible(false);
    }

    public void displayProximity(Pose6d tcpPose) {
        Pose6d tcpOffset = RobotState.getLatestRobotState().tcpOffset;
        Pose6d toolFlange = Pose6dTransformUtils.getPoseWithModifiedOffset((Pose6d)tcpPose, (Pose6d)tcpOffset, (Pose6d)new Pose6d());
        this.update(toolFlange);
    }

    public static class Update
    implements Runnable {
        private final ToolSphereVisualizer toolSphereVisualizer;

        public Update(ToolSphereVisualizer toolSphereVisualizer) {
            this.toolSphereVisualizer = toolSphereVisualizer;
        }

        @Override
        public void run() {
            RobotState robotState = RobotState.getLatestRobotState();
            Pose6d currentOutputFlangePose = ToolSphereVisualizer.getOutputFlangePose(robotState);
            this.toolSphereVisualizer.update(currentOutputFlangePose);
        }
    }

    private class WorkpieceConfigurationListener
    implements PropertyChangeListener {
        private WorkpieceConfiguration workpieceConfiguration = null;

        WorkpieceConfigurationListener(WorkpieceConfiguration workpieceConfiguration) {
            this.setWorkpieceConfiguration(workpieceConfiguration);
        }

        void setWorkpieceConfiguration(WorkpieceConfiguration workpieceConfiguration) {
            this.removeListener();
            this.workpieceConfiguration = workpieceConfiguration;
            workpieceConfiguration.addPropertyChangeListener(this);
        }

        private void removeListener() {
            if (this.workpieceConfiguration != null) {
                this.workpieceConfiguration.removePropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ToolSphereVisualizer.this.updateToolSpheres();
        }
    }
}

