/*
 * Decompiled with CFR 0.152.
 */
package com.ur.safety.workpiece.infrastructure;

import com.ur.math.Length;
import com.ur.polyscope.tcp.TCP;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ShowIcon;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvasbehavior.UpdateZoomInCanvas;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorWrapper;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.resources.ViewImageResource;
import com.ur.safety.Safety;
import com.ur.safety.SafetyTextResource;
import com.ur.safety.Settings;
import com.ur.safety.boundaries.infrastructure.Boundaries3DViewPanel;
import com.ur.safety.boundaries.infrastructure.BoundariesPanelImpl;
import com.ur.safety.util.externalapi.CoordinateValues;
import com.ur.safety.util.infrastructure.ActivatablePanel;
import com.ur.safety.util.infrastructure.SelectTCP;
import com.ur.safety.util.infrastructure.SetCoordinates;
import com.ur.safety.workpiece.domain.UIWorkpiece;
import com.ur.safety.workpiece.domain.WorkpieceLookup;
import com.ur.safety.workpiece.externalapi.PositionCoordinates;
import com.ur.safety.workpiece.externalapi.WorkpieceInputBinder;
import com.ur.safety.workpiece.externalapi.WorkpiecePresenter;
import com.ur.safety.workpiece.externalapi.WorkpieceView;
import com.ur.safety.workpiece.infrastructure.EditNameView;
import com.ur.safety.workpiece.infrastructure.ListView;
import com.ur.safety.workpiece.infrastructure.ListViewCellRenderer;
import com.ur.safety.workpiece.infrastructure.NameLengthValidationStrategy;
import com.ur.safety.workpiece.infrastructure.ToolSphereVisualizer;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputView;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.UnitsValueConverterFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.ActionableListCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jdesktop.swingx.JXLabel;

public class WorkpiecePanel
extends ActivatablePanel
implements WorkpieceView {
    public static final String TCP_COMBO_BOX = "tcpComboBox.WorkpiecePanel";
    public static final String WORKPIECE_PANEL = "workpiecePanel.Workpiecepanel";
    private static final String WORKPIECE_LIST = "workpieceList.WorkpiecePanel";
    private final WorkpiecePresenter presenter;
    private final WorkpieceInputBinder binder;
    private final ViewContext view;
    private final SafetyTextResource text;
    private final RenderingStrategy strategy;
    private final Boundaries3DViewPanel view3DPanel;
    private final ToolSphereVisualizer toolSphereVisualizer;
    private final HelpIdAssigner helpIdAssigner;
    private final ShowIcon showIcon;
    private JPanel workpiecesPanel;
    private WorkpieceCellRenderer workpieceRenderer;
    private WorkpieceList workpieces;
    private EditNameView renameWorkpiece;
    private SelectTCP tcpSelection;
    private SetCoordinates<PositionCoordinates> workpieceCenter;
    private WorkpieceRadius workpieceRadius;
    private final FeaturesLookup featuresLookup;
    private final WorkpieceLookup workpieceLookup;
    private JLabel noToolsDefinedWarningLabel;

    @Inject
    public WorkpiecePanel(WorkpiecePresenter presenter, WorkpieceInputBinder binder, ViewContext viewContext, @Named(value="tcp-renderer") @Named(value="tcp-renderer") RenderingStrategy strategy, Boundaries3DViewPanel view3DPanel, ToolSphereVisualizer toolSphereVisualizer, FeaturesLookup featuresLookup, WorkpieceLookup workpieceLookup, @Safety ShowIcon showIcon) {
        this.presenter = presenter;
        this.binder = binder;
        this.view = viewContext;
        this.text = (SafetyTextResource)viewContext.getTextResource(SafetyTextResource.class);
        this.strategy = strategy;
        this.view3DPanel = view3DPanel;
        this.toolSphereVisualizer = toolSphereVisualizer;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.featuresLookup = featuresLookup;
        this.workpieceLookup = workpieceLookup;
        this.showIcon = showIcon;
        this.initComponents(viewContext);
        presenter.setView(this);
    }

    @Override
    public void activate() {
        if (Settings.isRunningInDevelopmentMode()) {
            this.removeAll();
            this.initComponents(this.view);
        }
        this.view3DPanel.setActive(true);
        this.presenter.activate();
    }

    @Override
    public void deactivate() {
        this.view3DPanel.setActive(false);
        this.presenter.deactivate();
    }

    private void initComponents(ViewContext view) {
        UnitsConverter converter = Units.getMetersConverter();
        WidgetFactory widgetFactory = view.createWidgetFactory();
        this.setBackground(BoundariesPanelImpl.BETWEEN_CARD_COLOR);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BorderLayout(5, 5));
        this.workpieceRenderer = new WorkpieceCellRenderer(ListView.ADD_ELEMENT, widgetFactory, this.presenter, this.text);
        this.workpieces = new WorkpieceList(widgetFactory, WORKPIECE_LIST, this.workpieceRenderer, this.presenter, this.text);
        this.workpiecesPanel = new JPanel(new BorderLayout());
        this.workpiecesPanel.add(this.workpieces.list);
        this.renameWorkpiece = new RenameWorkpiece(widgetFactory, new NameLengthValidationStrategy(this.text), this.presenter);
        this.tcpSelection = new SelectTCP(this.presenter, view, this.strategy);
        this.workpieceCenter = new SetCoordinates<PositionCoordinates>(PositionCoordinates.class, this.presenter, this.binder, widgetFactory);
        this.workpieceRadius = new WorkpieceRadius(widgetFactory, this.binder, this.presenter);
        this.noToolsDefinedWarningLabel = this.getNoToolsDefinedWarningLabel();
        JPanel workpieceProperties = view.createFormBuilder().component((JComponent)this.noToolsDefinedWarningLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().end().end().component((JComponent)this.renameWorkpiece.panel, new FormBuilder.PanelConstraints[0]).end().end().label(this.text.radiusWithMax(converter.convertFrom(0.3), converter.getUnit()), new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.workpieceRadius.radius, new FormBuilder.PanelConstraints[0]).end().end().components((FormBuilder.Components)this.tcpSelection, new FormBuilder.PanelConstraints[0]).label(this.text.editPosition(), new FormBuilder.PanelConstraints[0]).end().components(this.workpieceCenter, new FormBuilder.PanelConstraints[0]).getPanel();
        this.workpiecesPanel.setBorder((Border)new CardBorder(this.text.tool()));
        workpieceProperties.setPreferredSize(new Dimension(320, 420));
        JPanel rightSideView = new JPanel(new BorderLayout(5, 5));
        rightSideView.setBackground(BoundariesPanelImpl.BETWEEN_CARD_COLOR);
        rightSideView.add((Component)this.workpiecesPanel, "Center");
        rightSideView.add((Component)workpieceProperties, "South");
        this.add((Component)rightSideView, "East");
        RobotCanvas3D canvas = this.view3DPanel.getRobotCanvas3D();
        if (canvas.isActualCanvas()) {
            canvas.addNodeToScene(this.toolSphereVisualizer.getElementNode());
        }
        canvas.alwaysRun((Runnable)new ToolSphereVisualizer.Update(this.toolSphereVisualizer));
        this.add((Component)((Object)this.view3DPanel), "Center");
        ViewBehaviorWrapper wrapper = new ViewBehaviorWrapper(this.featuresLookup);
        this.view3DPanel.getRobotCanvas3D().addJ3DComponent((J3DComponent)new ZoomRenderer(this.view3DPanel.getRobotCanvas3D().getComponent(), (ViewBehaviorHolder)wrapper));
        this.view3DPanel.getRobotCanvas3D().alwaysRun((Runnable)new UpdateZoomInCanvas((ViewBehaviorHolder)wrapper));
        this.view3DPanel.setBorder((Border)new CardBorder(this.text.Robot()));
        this.view3DPanel.setElementVisualizers(this.toolSphereVisualizer);
        this.setName(WORKPIECE_PANEL);
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this.view3DPanel), "gui:installation_safety_boundaries_3d_view");
        this.helpIdAssigner.assignHelpId((JComponent)this.workpiecesPanel, "gui:installation_safety_tool_position");
        this.helpIdAssigner.assignHelpId((JComponent)workpieceProperties, "gui:installation_safety_tool_position");
    }

    @Override
    public void setWorkpieces(List<UIWorkpiece> uiWorkpieces) {
        this.workpieces.setAvailableElements(uiWorkpieces);
        this.updateWorkpiecesCount();
        this.updateWarningLabelVisibility();
    }

    @Override
    public void selectWorkpiece(UIWorkpiece activeWorkpiece) {
        this.workpieces.setSelectedElement(activeWorkpiece);
        this.updateWorkpiecesCount();
    }

    private void updateWorkpiecesCount() {
        int countOfWorkpieces = this.workpieces.getWorkpieceCount();
        this.workpiecesPanel.setBorder((Border)new CardBorder(String.valueOf(this.text.tool()) + " (" + countOfWorkpieces + " of 3)"));
    }

    @Override
    public void highlightSphere(int index) {
        this.toolSphereVisualizer.highlight(index);
    }

    @Override
    public void notifyDeletionOfLastWorkpiece() {
        this.workpieces.displayNotificationOfLastWorkpieceRemoved();
    }

    @Override
    public void setTCPList(List<TCP> allTCPs) {
        this.tcpSelection.setTCPs(allTCPs);
    }

    @Override
    public void setWorkpieceName(String name) {
        this.renameWorkpiece.setName(name);
        this.workpieces.list.repaint();
    }

    @Override
    public void selectTCP(SelectTCP.Definition definition) {
        this.tcpSelection.setSelection(definition);
    }

    @Override
    public void selectTCP(TCP tcp) {
        this.tcpSelection.setSelection(tcp);
    }

    @Override
    public void setWorkpieceCenter(CoordinateValues<PositionCoordinates> values) {
        this.workpieceCenter.setCoordinate(values);
    }

    @Override
    public void setSynchronizationPossible(boolean isEnabled) {
        this.tcpSelection.setSynchronizationPossible(isEnabled);
    }

    @Override
    public void setWorkpieceRadius(Length radius) {
        this.workpieceRadius.setRadius(radius);
    }

    @Override
    public void enableWorkpieces(boolean isEnabled) {
        this.workpieces.setEnabled(isEnabled);
        this.workpieceRenderer.setEnabled(isEnabled);
        this.workpiecesPanel.repaint();
    }

    @Override
    public void enableProperties(boolean isEnabled) {
        this.workpieceRadius.setEnabled(isEnabled);
        this.workpieceCenter.setEnabled(isEnabled);
        this.renameWorkpiece.setEnabled(isEnabled);
        this.tcpSelection.setEnabled(isEnabled);
    }

    @Override
    public Errorable.Status getStatus() {
        return null;
    }

    @Override
    public void addStatusListener(Errorable.StatusListener listener) {
    }

    @Override
    public void removeStatusListener(Errorable.StatusListener listener) {
    }

    private JLabel getNoToolsDefinedWarningLabel() {
        JXLabel label = new JXLabel(this.text.noToolsDefinedWarning());
        label.setIcon(ViewImageResource.formWarning());
        label.setName("toolPositionWarning");
        label.setVisible(!this.workpieceLookup.isToolsDefined());
        label.setLineWrap(true);
        return label;
    }

    private void updateWarningLabelVisibility() {
        this.noToolsDefinedWarningLabel.setVisible(!this.workpieceLookup.isToolsDefined());
        if (this.workpieceLookup.isToolsDefined()) {
            this.showIcon.clearIcon((Component)this);
        } else {
            this.showIcon.show(ViewImageResource.formWarning(), (Component)this);
        }
    }

    private static class RenameWorkpiece
    extends EditNameView {
        private final WorkpiecePresenter presenter;

        RenameWorkpiece(WidgetFactory widgetFactory, ValidationStrategy nameValidationStrategy, WorkpiecePresenter presenter) {
            super(widgetFactory, nameValidationStrategy);
            this.presenter = presenter;
        }

        @Override
        protected void updateName(String text) {
            this.presenter.setName(text);
        }
    }

    private static class WorkpieceCellRenderer
    extends ListViewCellRenderer<UIWorkpiece> {
        private final WorkpiecePresenter presenter;
        private final SafetyTextResource text;

        WorkpieceCellRenderer(Object addElement, WidgetFactory widgetFactory, WorkpiecePresenter presenter, SafetyTextResource text) {
            super(addElement, widgetFactory, ListViewCellRenderer.ShowVisibilityToggle.NO);
            this.presenter = presenter;
            this.text = text;
        }

        @Override
        protected String getText(UIWorkpiece element) {
            return element.getName();
        }

        @Override
        protected boolean isVisible(UIWorkpiece element) {
            return element.isVisible();
        }

        @Override
        protected boolean canDelete(UIWorkpiece element) {
            return this.presenter.canDelete();
        }

        @Override
        public boolean showDeleteIcon() {
            return this.presenter.canDelete();
        }

        @Override
        protected String getAddElementText() {
            return this.text.addWorkpiece();
        }
    }

    private static class WorkpieceList
    extends ListView<UIWorkpiece> {
        private final WorkpiecePresenter presenter;
        private final SafetyTextResource text;

        WorkpieceList(WidgetFactory widgetFactory, String name, ActionableListCellRenderer renderer, WorkpiecePresenter presenter, SafetyTextResource text) {
            super(widgetFactory, name, renderer);
            this.presenter = presenter;
            this.text = text;
        }

        @Override
        protected void selectElement(UIWorkpiece element) {
            this.presenter.selectWorkpiece(element);
        }

        @Override
        protected void setVisible() {
        }

        @Override
        protected void addElement() {
            if (this.presenter.canAddMore()) {
                this.presenter.addWorkpiece();
            }
        }

        @Override
        protected void removeElement() {
            if (this.presenter.canDelete()) {
                this.presenter.deleteWorkpiece();
            }
        }

        @Override
        protected boolean canAddMore() {
            return this.presenter.canAddMore();
        }

        void displayNotificationOfLastWorkpieceRemoved() {
            DisplayMessageFactory.inform((JComponent)this.list, (String)this.text.deleteLastResetsToDefault());
        }

        private int getWorkpieceCount() {
            return this.presenter.workpieceCount();
        }
    }

    private static class WorkpieceRadius
    implements ActionListener {
        final NumberField radius;
        private final WorkpiecePresenter presenter;

        WorkpieceRadius(WidgetFactory widgetFactory, WorkpieceInputBinder binder, WorkpiecePresenter presenter) {
            this.presenter = presenter;
            this.radius = widgetFactory.createNumberField((ActionListener)this, UnitsValueConverterFactory.getLengthConverter());
            this.radius.setNumberFieldWidth(320, 100);
            binder.bindWorkpieceRadiusSupport((InputView)this.radius);
        }

        public void setRadius(Length radius) {
            this.radius.setValue((Object)radius);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.presenter.setRadius((Length)this.radius.getValue());
        }

        public void setEnabled(boolean enabled) {
            this.radius.setEnabled(enabled);
        }
    }
}

