/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.simulation.internal;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Function;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.monitor.model.RobotMode;
import com.ur.polyscope.simulation.RobotDeviceService;
import com.ur.polyscope.simulation.internal.RobotModeSendToController;
import com.ur.polyscope.simulation.internal.SimulationView;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class RobotDeviceServiceImpl
implements RobotDeviceService {
    private final Set<Class<?>> simulatedDeviceVetos = new HashSet();
    private final Set<Class<?>> viewLocks = new HashSet();
    private SimulationView view = new NullView();
    private final Provider<Arm> armProvider;
    private final Recipe<Arm> armStream;
    private final Recipe<RobotMode> robotModeStream;

    @Inject
    public RobotDeviceServiceImpl(@Source(value=Arm.class) Recipe<Arm> armStream, @Source(value=RobotMode.class) Recipe<RobotMode> robotModeStream) {
        this.armProvider = armStream.lastProvider();
        this.armStream = armStream;
        this.robotModeStream = robotModeStream;
    }

    public void setView(final SimulationView view) {
        this.view = view;
        this.robotModeStream.map((Function)new Function<RobotMode, Boolean>(){

            public Boolean call(RobotMode robotMode) {
                return !robotMode.isProgramRunning() && !robotMode.isProgramPaused();
            }
        }).distinctUntilChanged().executeOnUIThread().subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean stopped) {
                if (stopped.booleanValue()) {
                    RobotDeviceServiceImpl.this.removeViewLock(RobotMode.class);
                } else {
                    RobotDeviceServiceImpl.this.addViewLock(RobotMode.class);
                }
            }
        });
        this.armStream.map((Function)new Function<Arm, Boolean>(){

            public Boolean call(Arm arm) {
                return arm.isRealRobot();
            }
        }).distinctUntilChanged().executeOnUIThread().subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean isReal) {
                view.robotDeviceStateUpdate(isReal);
            }
        });
    }

    public void addViewLock(Class<?> type) {
        this.viewLocks.add(type);
        this.view.enable(false);
    }

    public void removeViewLock(Class<?> type) {
        this.viewLocks.remove(type);
        if (this.viewLocks.isEmpty() && this.simulatedDeviceVetos.isEmpty()) {
            this.view.enable(true);
        }
    }

    public boolean isSimulated() {
        return !this.isReal();
    }

    public boolean isReal() {
        return ((Arm)this.armProvider.get()).isRealRobot();
    }

    public void addSimulatedDeviceVeto(Class<?> type) {
        this.simulatedDeviceVetos.add(type);
        this.sendSetRealRobot();
        this.view.robotDeviceStateUpdate(true);
        this.view.enable(false);
    }

    public void removeSimulatedDeviceVeto(Class<?> type) {
        this.simulatedDeviceVetos.remove(type);
        if (this.simulatedDeviceVetos.isEmpty() && this.viewLocks.isEmpty()) {
            this.view.enable(true);
        }
    }

    public void sendSetSimulatedRobot() {
        if (this.isReal()) {
            RobotModeSendToController.sendSetSimulatedRobot();
        }
    }

    public void sendSetRealRobot() {
        if (!this.isReal()) {
            RobotModeSendToController.sendSetRealRobot();
        }
    }

    private static class NullView
    implements SimulationView {
        private NullView() {
        }

        @Override
        public void robotDeviceStateUpdate(boolean isReal) {
        }

        @Override
        public void enable(boolean enable) {
        }
    }
}

