/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.simulation.internal.presentation;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Function;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.polyscope.simulation.internal.presentation.MapSimulationMode;
import com.ur.swing.extensible.ApplicationStateVisualization;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.ViewLayout;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.Color;
import javax.inject.Inject;

@Extension(value="HeaderMenu")
public class HeaderFooterSimulationModeVisualization
implements ApplicationStateVisualization {
    public static final Color SIMULATION_BACKGROUND = new Color(24, 90, 155);
    public static final Color SIMULATION_SELECTED = new Color(86, 160, 211);
    private Recipe<Arm> robotModeRecipe;
    private MapSimulationMode armToSimulationMode;

    @Inject
    public HeaderFooterSimulationModeVisualization(@Source(value=Arm.class) Recipe<Arm> robotModeRecipe, MapSimulationMode simulationMode) {
        this.robotModeRecipe = robotModeRecipe;
        this.armToSimulationMode = simulationMode;
    }

    public void setHeader(final ViewLayout headerMenu) {
        this.robotModeRecipe.executeOnIOThread().map((Function)this.armToSimulationMode).distinctUntilChanged().executeOnUIThread().forEach((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean isSimulationMode) {
                headerMenu.setBackground(isSimulationMode != false ? SIMULATION_BACKGROUND : G5LookAndFeel.HEADER_BACKGROUND);
                headerMenu.setSelectedColor(isSimulationMode != false ? SIMULATION_SELECTED : G5LookAndFeel.SELECTED_HEADER_BACKGROUND);
            }
        });
    }
}

