/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.simulation.internal.presentation;

import com.ur.lang.react.Consumer;
import com.ur.lang.react.Function;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Arm;
import com.ur.polyscope.simulation.internal.TextResource;
import com.ur.polyscope.simulation.internal.presentation.MapSimulationMode;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.Layer;
import com.ur.swing.extensible.LayerExtension;
import com.ur.util.logging.Log;
import java.util.Collection;
import java.util.HashSet;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;

@Extension(value="InitializeRobotLabel")
public class SimulatedRobotStatusLayer
implements LayerExtension,
Layer {
    private Recipe<Arm> armRecipe;
    private MapSimulationMode armToSimulationMode;
    private TextResource text;
    private JLabel containedLabel;

    @Inject
    public SimulatedRobotStatusLayer(@Source(value=Arm.class) Recipe<Arm> armRecipe, MapSimulationMode simulationMode, TextResource text) {
        this.armRecipe = armRecipe;
        this.armToSimulationMode = simulationMode;
        this.text = text;
    }

    public Layer createLayer() {
        return this;
    }

    public JComponent decorate(JComponent jComponent) {
        this.containedLabel = this.getLabel(jComponent);
        this.armRecipe.executeOnUIThread().map((Function)this.armToSimulationMode).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean isRealRobot) {
                SimulatedRobotStatusLayer.this.changeTextWhenInSimulationMode(isRealRobot);
            }
        });
        return jComponent;
    }

    private JLabel getLabel(JComponent jComponent) {
        if (jComponent instanceof JLabel) {
            return (JLabel)jComponent;
        }
        return this.returnDummyLabel();
    }

    private JLabel returnDummyLabel() {
        Log.error((String)"Failed to find the JLabel for InitializeRobot.RobotStatus");
        JLabel result = new JLabel();
        result.putClientProperty("vetoes", new HashSet());
        return result;
    }

    private void changeTextWhenInSimulationMode(Boolean isSimulationMode) {
        Collection vetos = (Collection)this.containedLabel.getClientProperty("vetoes");
        if (!isSimulationMode.booleanValue()) {
            vetos.remove(this);
        } else if (vetos.isEmpty()) {
            vetos.add(this);
            this.containedLabel.setText(this.text.Simulation());
        }
    }
}

