/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.simulation.internal.presentation;

import com.ur.polyscope.controllerinterface.ControllerSocketListener;
import com.ur.polyscope.simulation.internal.RobotDeviceServiceImpl;
import com.ur.polyscope.simulation.internal.SimulationView;
import com.ur.polyscope.simulation.internal.TextResource;
import com.ur.polyscope.simulation.internal.presentation.UserRequested;
import com.ur.swing.OnOffSwitch;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.event.EventManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

@Extension(value="Footer")
@Singleton
public class SimulationViewImpl
extends JPanel
implements SimulationView,
MenuExtension {
    private final RobotDeviceServiceImpl deviceService;
    private final TextResource textResource;
    private final UserRequested userRequested;
    private final OnOffSwitch simulationSwitch = new OnOffSwitch(){

        public String getUIClassID() {
            return "OnOffSwitchUIGray";
        }
    };

    @Inject
    public SimulationViewImpl(RobotDeviceServiceImpl deviceService, TextResource textResource, EventManager eventManager, UserRequested userRequested) {
        this.deviceService = deviceService;
        this.textResource = textResource;
        this.userRequested = userRequested;
        this.initComponents();
        eventManager.addStrongListener(ControllerSocketListener.class, (Object)new ControllerSocketListener(){

            public void socketEvent(boolean isConnected) {
                SimulationViewImpl.this.simulationSwitch.setEnabled(isConnected);
            }
        });
    }

    private void initComponents() {
        this.deviceService.setView(this);
        this.simulationSwitch.setName(SimulationView.SIMULATION_SWITCH);
        this.simulationSwitch.setText(this.textResource.Simulation());
        this.simulationSwitch.setForeground(UIManager.getColor("Footer.foreground"));
        this.simulationSwitch.setBackground(UIManager.getColor("Footer.background"));
        this.simulationSwitch.setHorizontalTextPosition(2);
        this.simulationSwitch.setFocusable(false);
        this.simulationSwitch.addActionListener((ActionListener)new SimulationSwitchListener());
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.add((Component)this.simulationSwitch);
    }

    @Override
    public void robotDeviceStateUpdate(boolean isReal) {
        if (isReal) {
            this.simulationSwitch.setSelected(false);
            this.userRequested.setUserRequested(false);
        }
    }

    @Override
    public void enable(boolean enable) {
        this.simulationSwitch.setEnabled(enable);
    }

    public MenuExtension.MenuContribution create() {
        return MenuExtension.MenuContribution.locateLast((MenuExtension.MenuContribution)new MenuExtension.ComponentMenuContribution((JComponent)this, "RIGHT", MenuExtension.MenuContribution.Restrictions.NO_RESTRICTION));
    }

    class SimulationSwitchListener
    implements ActionListener {
        SimulationSwitchListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SimulationViewImpl.this.simulationSwitch.isSelected()) {
                SimulationViewImpl.this.deviceService.sendSetSimulatedRobot();
                SimulationViewImpl.this.userRequested.setUserRequested(true);
            } else {
                SimulationViewImpl.this.deviceService.sendSetRealRobot();
                SimulationViewImpl.this.userRequested.setUserRequested(false);
            }
        }
    }
}

