/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.common;

import com.ur.lang.Defense;
import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.payload.common.PayloadComponentScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PayloadComponent
implements DomainComponent {
    static final double METERS_EPSILON = 2.0E-6;
    static final double KG_M_SQ_EPSILON = 9.0E-7;
    private final boolean customInertiaEnabled;
    public static final PayloadComponent ZERO_PAYLOAD = new PayloadComponent(Weight.ZERO, new Vector3d(), new Matrix3d(), false);
    private final Weight mass;
    private final Vector3d centerOfGravity;
    private final Matrix3d inertiaMatrix;

    public PayloadComponent(PayloadComponent original) {
        this(original.mass, original.centerOfGravity, original.inertiaMatrix, original.customInertiaEnabled);
    }

    public PayloadComponent(PayloadComponent original, boolean customInertiaEnabled) {
        this(original.mass, original.centerOfGravity, original.inertiaMatrix, customInertiaEnabled);
    }

    public PayloadComponent(Weight mass, Vector3d centerOfGravity, Matrix3d inertiaMatrix) {
        this(mass, centerOfGravity, inertiaMatrix, false);
    }

    public PayloadComponent(Weight mass, Vector3d centerOfGravity, Matrix3d inertiaMatrix, boolean customInertiaEnabled) {
        Defense.notNull((Object)mass);
        Defense.notNull((Object)centerOfGravity);
        Defense.notNull((Object)inertiaMatrix);
        this.mass = mass;
        this.centerOfGravity = centerOfGravity;
        this.inertiaMatrix = inertiaMatrix;
        this.customInertiaEnabled = customInertiaEnabled;
    }

    public Weight getMass() {
        return this.mass;
    }

    public Vector3d getCenterOfGravity() {
        return new Vector3d(this.centerOfGravity);
    }

    public Matrix3d getInertiaMatrix() {
        return new Matrix3d(this.inertiaMatrix);
    }

    public boolean isCustomInertiaEnabled() {
        return this.customInertiaEnabled;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isDefined() {
        return true;
    }

    public void writeScript(ScriptWriter scriptWriter) {
        PayloadComponentScriptGenerator scriptGenerator = new PayloadComponentScriptGenerator();
        String script = scriptGenerator.generateScript(this);
        scriptWriter.writeScript(script);
    }

    public void writeScript(ScriptWriter scriptWriter, Time transitionTime) {
        PayloadComponentScriptGenerator scriptGenerator = new PayloadComponentScriptGenerator();
        String script = scriptGenerator.generateScriptWithTransitionTime(this, transitionTime);
        scriptWriter.writeScript(script);
    }

    public String asValue() {
        return String.valueOf(this.formatMass(this.mass)) + " " + this.formatCog(this.centerOfGravity);
    }

    private String formatCog(Vector3d cog) {
        String cogX = this.getLengthAsString(cog.x);
        String cogY = this.getLengthAsString(cog.y);
        String cogZ = this.getLengthAsString(cog.z);
        return "CoG=[" + cogX + ", " + cogY + ", " + cogZ + "]";
    }

    private String getLengthAsString(Double length) {
        return this.formatLength(Length.from((double)length, (Length.Unit)Length.Unit.M));
    }

    private String formatLength(Length length) {
        ValueConverter lengthConverter = UnitsValueConverterFactory.getLengthConverter();
        return String.valueOf(lengthConverter.getFormat().format(Double.parseDouble((String)lengthConverter.fromModel((Object)length)))) + lengthConverter.getUnit();
    }

    private String formatMass(Weight weight) {
        ValueConverter weightConverter = UnitsValueConverterFactory.getWeightConverter();
        return String.valueOf(weightConverter.getFormat().format(Double.parseDouble((String)weightConverter.fromModel((Object)weight)))) + weightConverter.getUnit();
    }

    public String toString() {
        return "mass=" + this.mass + "; centerOfGravity=" + this.centerOfGravity + String.format("; Ixx=%f, Iyy=%f, Izz=%f, Ixy=%f, Ixz=%f, Iyz=%f", this.inertiaMatrix.m00, this.inertiaMatrix.m11, this.inertiaMatrix.m22, this.inertiaMatrix.m01, this.inertiaMatrix.m02, this.inertiaMatrix.m12);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayloadComponent other = (PayloadComponent)o;
        return this.mass.equals((Object)other.mass) && this.centerOfGravity.epsilonEquals((Tuple3d)other.centerOfGravity, 2.0E-6) && this.inertiaMatrix.epsilonEquals(other.inertiaMatrix, 9.0E-7) && this.customInertiaEnabled == other.customInertiaEnabled;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.mass.hashCode();
        hash = 31 * hash + this.centerOfGravity.hashCode();
        hash = 31 * hash + this.inertiaMatrix.hashCode();
        return hash;
    }

    public boolean isUserDefined() {
        return true;
    }
}

