/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.common;

import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.Weight;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;

public class PayloadComponentScriptGenerator {
    private static final String SET_TARGET_PAYLOAD_TEMPLATE = "set_target_payload(%f, [%f, %f, %f], [%f, %f, %f, %f, %f, %f])";
    private static final String SET_TARGET_PAYLOAD_WITH_TRANSITION_TIME_TEMPLATE = "set_target_payload(%f, [%f, %f, %f], [%f, %f, %f, %f, %f, %f], %f)";

    public String generateScript(PayloadComponent payloadComponent) {
        return this.getFormattedScriptString(SET_TARGET_PAYLOAD_TEMPLATE, this.getValuesFromPayloadComponent(payloadComponent));
    }

    public String generateScriptWithTransitionTime(PayloadComponent payloadComponent, Time transitionTime) {
        Object[] valuesFromPayloadComponent1 = this.getValuesFromPayloadComponent(payloadComponent);
        ArrayList<Object> valuesList = new ArrayList<Object>(Arrays.asList(valuesFromPayloadComponent1));
        valuesList.add(transitionTime.getIn(Time.Unit.SECONDS));
        return this.getFormattedScriptString(SET_TARGET_PAYLOAD_WITH_TRANSITION_TIME_TEMPLATE, valuesList.toArray(new Object[0]));
    }

    private String getFormattedScriptString(String scriptTemplate, Object ... values) {
        return String.format(Locale.ENGLISH, scriptTemplate, values);
    }

    private Object[] getValuesFromPayloadComponent(PayloadComponent payloadComponent) {
        Vector3d centerOfGravity = payloadComponent.getCenterOfGravity();
        Matrix3d inertiaMatrix = payloadComponent.getInertiaMatrix();
        double massInKG = payloadComponent.getMass().getIn(Weight.Unit.KG);
        return new Object[]{massInKG, centerOfGravity.x, centerOfGravity.y, centerOfGravity.z, inertiaMatrix.m00, inertiaMatrix.m11, inertiaMatrix.m22, inertiaMatrix.m01, inertiaMatrix.m02, inertiaMatrix.m12};
    }
}

