/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.payload.common;

import com.ur.polyscope.application.DomainComponent;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponentScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Time;
import com.ur.reference.NameReference;
import java.util.Objects;

public class PayloadReferenceComponent
extends NameReference<InstallationPayloadComponent>
implements DomainComponent {
    private static final PayloadComponentScriptGenerator SCRIPT_GENERATOR = new PayloadComponentScriptGenerator();
    private final PayloadService payloadService;

    public PayloadReferenceComponent(String referencedName, PayloadService payloadService) {
        super(referencedName);
        this.payloadService = payloadService;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isDefined() {
        return Objects.nonNull(this.dereference());
    }

    public void writeScript(ScriptWriter scriptWriter) {
        InstallationPayloadComponent actualPayload = this.dereference();
        if (Objects.nonNull(actualPayload)) {
            scriptWriter.writeScript(SCRIPT_GENERATOR.generateScript(actualPayload));
        }
    }

    public void writeScript(ScriptWriter scriptWriter, Time transitionTime) {
        InstallationPayloadComponent actualPayload = this.dereference();
        if (Objects.nonNull(actualPayload)) {
            scriptWriter.writeScript(SCRIPT_GENERATOR.generateScriptWithTransitionTime(actualPayload, transitionTime));
        }
    }

    public String asValue() {
        return this.getKey();
    }

    public InstallationPayloadComponent dereference() {
        return this.payloadService.getPayloadByName(this.getKey());
    }

    public String toString() {
        InstallationPayloadComponent payloadComponent = this.dereference();
        String payloadString = Objects.nonNull(payloadComponent) ? ((PayloadComponent)payloadComponent).toString() : "";
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "; " + payloadString;
    }
}

