/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal;

import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.polyscope.flightrecorder.FlightRecorder;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderReporter;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.ReportDescription;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.internal.MinimumDelay;
import com.ur.polyscope.flightrecorder.internal.ReportDescriptionImpl;
import com.ur.util.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FlightRecorderImpl
implements FlightRecorder {
    private static final int MINIMUM_REPORTING_INTERVAL_MS = 30000;
    private static final String FEATURE_NO_INTERVAL = "FLIGHTRECORDER_NO_INTERVAL";
    public static final Pattern flightReportIdentifierPattern = Pattern.compile("\\d{8}(_\\d\\d){3}");
    public static final String FLIGHTRECORDING_PREFIX = "recording";
    public static final String CONFIGURATION_REPORT_PREFIX = "robot_configuration";
    private final MinimumDelay minimumDelay;
    private final ScheduledExecutorService executor;
    private final Collection<FlightRecorderProbe> probes;
    private final FlightRecorderReporter reporter;

    @Inject
    public FlightRecorderImpl(Set<FlightRecorderProbe> probes, FlightRecorderReporter reporter) {
        this(Executors.newSingleThreadScheduledExecutor(), probes, reporter, 30000L);
    }

    public FlightRecorderImpl(ScheduledExecutorService executor, final Set<FlightRecorderProbe> probes, FlightRecorderReporter reporter, long minimumDelayMS) {
        this.executor = executor;
        this.probes = probes;
        this.reporter = reporter;
        this.minimumDelay = new MinimumDelay(minimumDelayMS);
        Log.info((String)"generated flight recorder");
        for (FlightRecorderProbe probe : probes) {
            probe.start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (FlightRecorderProbe probe : probes) {
                    probe.stop();
                }
            }
        });
    }

    public ReportDescription reportIncident(FlightRecorderTriggerType triggerType) {
        return this.reportIncident(0, triggerType);
    }

    public ReportDescription reportIncident(int delayMS, FlightRecorderTriggerType triggerType) {
        return this.scheduleIncidentReport(null, delayMS, triggerType);
    }

    public ReportDescription reportIncident(Throwable exception, int delayMS, FlightRecorderTriggerType triggerType) {
        return this.scheduleIncidentReport(exception, delayMS, triggerType);
    }

    private ReportDescription scheduleIncidentReport(Throwable exception, int delayMS, FlightRecorderTriggerType triggerType) {
        Date incidentTime = new Date();
        ReportDescriptionImpl reportDescription = null;
        if (this.minimumDelay.checkAndSet(incidentTime) || triggerType == FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT || FeatureToggle.isActive((String)FEATURE_NO_INTERVAL)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HH_mm_ss");
            String reportFilePrefix = triggerType == FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT ? CONFIGURATION_REPORT_PREFIX : FLIGHTRECORDING_PREFIX;
            String reportIdentifier = reportFilePrefix + dateFormat.format(new Date());
            reportDescription = new ReportDescriptionImpl(incidentTime, reportIdentifier, triggerType);
            CreateIncidentReportTask task = new CreateIncidentReportTask(exception, reportDescription);
            ScheduledFuture<?> incidentReportTaskStatus = this.executor.schedule(task, (long)delayMS, TimeUnit.MILLISECONDS);
            reportDescription.setFutureReportStatus(incidentReportTaskStatus);
        } else {
            Log.warning((String)"Incident reporting skipped (too frequent incidents).");
        }
        return reportDescription;
    }

    private static class IncidentProbe
    implements FlightRecorderProbe {
        private final Throwable exception;
        private final Date incidentTime;
        private final Date reportingTime;

        public IncidentProbe(Throwable exception, Date incidentTime, Date reportingTime) {
            this.exception = exception;
            this.incidentTime = incidentTime;
            this.reportingTime = reportingTime;
        }

        public String getName() {
            return "Incident Report";
        }

        public void write(PrintStream out) {
            out.println("Incident Time: " + this.incidentTime);
            out.println("Reporting Time: " + this.reportingTime);
            if (this.exception != null) {
                out.println("Stack Trace:");
                this.exception.printStackTrace(out);
            }
        }

        public List<FlightRecorderAttachment> getFileAttachments() {
            return Collections.emptyList();
        }

        public void start() {
        }

        public void stop() {
        }

        public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
            return EnumSet.allOf(FlightRecorderTriggerType.class);
        }
    }

    private final class CreateIncidentReportTask
    implements Runnable {
        private final Throwable exception;
        private final ReportDescriptionImpl reportDescription;
        private final ByteArrayOutputStream reportProgressSummary;

        private CreateIncidentReportTask(Throwable exception, ReportDescriptionImpl recentReportProgress) {
            this.exception = exception;
            this.reportDescription = recentReportProgress;
            this.reportProgressSummary = new ByteArrayOutputStream();
        }

        @Override
        public void run() {
            this.doReportIncident(this.exception, new Date());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doReportIncident(Throwable exception, Date reportingTime) {
            IncidentProbe meta = new IncidentProbe(exception, this.reportDescription.getIncidentTime(), reportingTime);
            try {
                FlightRecorderImpl.this.reporter.open(this.reportDescription.getReportId(), this.reportDescription.getTriggerType());
                this.writeReport(FlightRecorderImpl.this.reporter, meta);
            }
            catch (RuntimeException x) {
                Log.error((String)"Uncaught exception while reporting incident.", (Throwable)x);
            }
            finally {
                FlightRecorderImpl.this.reporter.close();
            }
            this.reportDescription.updateSummary(this.reportProgressSummary.toString());
        }

        private void writeReport(FlightRecorderReporter reporter, FlightRecorderProbe meta) {
            this.writeProbe(reporter, meta);
            for (FlightRecorderProbe probe : FlightRecorderImpl.this.probes) {
                try {
                    if (!probe.getApplicableReportTypes().contains(this.reportDescription.getTriggerType())) continue;
                    this.writeProbe(reporter, probe);
                }
                catch (RuntimeException ex) {
                    Log.error((String)("Probe: " + probe.getName() + " failed"), (Throwable)ex);
                    reporter.getWriter().println("Probe: " + probe.getName() + " failed with error: " + ex.getMessage());
                }
            }
        }

        private void writeProbe(FlightRecorderReporter reporter, FlightRecorderProbe probe) {
            PrintStream summary = new PrintStream(this.reportProgressSummary);
            PrintStream out = reporter.getWriter();
            out.println("== " + probe.getName() + " ==");
            summary.println("== " + probe.getName() + " ==");
            out.println();
            probe.write(out);
            out.println();
            summary.println();
            probe.write(summary);
            summary.println();
            reporter.addAttachments(probe.getFileAttachments());
        }
    }
}

