/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.attachment;

import com.ur.polyscope.flightrecorder.attachment.FileAttachmentConfiguration;
import com.ur.polyscope.flightrecorder.internal.FlightRecorderSettings;
import java.io.File;

public class FileAttachmentConfigurationImpl
implements FileAttachmentConfiguration {
    private File sourceFile;
    private String targetDirectory = "";
    private String targetFileName;
    private int maxTextFileSize;
    private String mimeType;

    public FileAttachmentConfigurationImpl(FlightRecorderSettings settings) {
        this.maxTextFileSize = settings.getDefaultFileSizeLimit();
    }

    public FileAttachmentConfigurationImpl setFile(File file) {
        this.sourceFile = file;
        return this;
    }

    public FileAttachmentConfigurationImpl setTargetDirectoryPath(String targetDirectory) {
        this.targetDirectory = targetDirectory;
        return this;
    }

    public FileAttachmentConfigurationImpl setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
        return this;
    }

    public FileAttachmentConfigurationImpl setMaxTextFileSize(int maxTextFileSize) {
        this.maxTextFileSize = maxTextFileSize;
        return this;
    }

    public FileAttachmentConfigurationImpl setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public File getFile() {
        return this.sourceFile;
    }

    public String getTargetDirectoryPath() {
        if (this.targetDirectory.length() > 0 && !this.targetDirectory.endsWith(File.separator)) {
            return this.targetDirectory + File.separator;
        }
        return this.targetDirectory;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    public int getMaxTextFileSize() {
        return this.maxTextFileSize;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

