/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.attachment;

import com.ur.polyscope.flightrecorder.attachment.FileAttachmentConfiguration;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.polyscope.flightrecorder.internal.FlightRecorderSettings;
import com.ur.polyscope.flightrecorder.internal.attachment.FileAttachmentConfigurationImpl;
import com.ur.polyscope.flightrecorder.internal.attachment.FlightRecorderByteArrayAttachment;
import com.ur.polyscope.flightrecorder.internal.attachment.FlightRecorderCommandAttachment;
import com.ur.polyscope.flightrecorder.internal.attachment.FlightRecorderTextFileAttachment;
import java.io.File;
import javax.inject.Inject;

public class FlightRecorderAttachmentFactoryImpl
implements FlightRecorderAttachmentFactory {
    private final FlightRecorderSettings settings;

    @Inject
    FlightRecorderAttachmentFactoryImpl(FlightRecorderSettings settings) {
        this.settings = settings;
    }

    public FileAttachmentConfiguration getFileAttachmentConfiguration() {
        return new FileAttachmentConfigurationImpl(this.settings);
    }

    public FlightRecorderAttachment getTextFileAttachment(FileAttachmentConfiguration configuration) {
        if (configuration.getFile() == null) {
            throw new IllegalArgumentException("Source file is required");
        }
        if (configuration.getMimeType() == null) {
            throw new IllegalArgumentException("MIME type is required");
        }
        String targetFileName = configuration.getTargetFileName();
        if (targetFileName == null) {
            targetFileName = configuration.getFile().getName();
        }
        return new FlightRecorderTextFileAttachment(configuration.getFile(), configuration.getTargetDirectoryPath() + targetFileName, configuration.getMaxTextFileSize(), configuration.getMimeType());
    }

    public FlightRecorderAttachment getByteArrayAttachment(byte[] bytes, String targetFileName, String mimeType) {
        return new FlightRecorderByteArrayAttachment(targetFileName, bytes, mimeType);
    }

    public FlightRecorderAttachment getByteArrayAttachment(byte[] bytes, String targetDirectory, String targetFileName, String mimeType) {
        return new FlightRecorderByteArrayAttachment(targetDirectory + File.separator + targetFileName, bytes, mimeType);
    }

    public FlightRecorderAttachment getShellCommandAttachment(String command, String targetFileName, String mimeType) {
        return new FlightRecorderCommandAttachment(targetFileName, command, mimeType);
    }

    public FlightRecorderAttachment getShellCommandAttachment(String command, String targetDirectory, String targetFileName, String mimeType) {
        return new FlightRecorderCommandAttachment(targetDirectory + File.separator + targetFileName, command, mimeType);
    }
}

