/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.attachment;

import com.google.common.io.ByteStreams;
import com.ur.lang.IOUtil;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.util.logging.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FlightRecorderTextFileAttachment
implements FlightRecorderAttachment {
    private final File file;
    private String mimeType;
    private final String name;
    private final int maxSize;

    FlightRecorderTextFileAttachment(File file, String targetName, int maxSize, String mimeType) {
        this.file = file;
        this.name = targetName;
        this.maxSize = maxSize;
        this.mimeType = mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(this.file);
            if (this.file.length() > (long)this.maxSize) {
                int b;
                ByteStreams.skipFully((InputStream)fs, (long)(this.file.length() - (long)this.maxSize));
                while ((b = ((InputStream)fs).read()) != 10 && b != -1) {
                }
            }
            ByteStreams.copy((InputStream)fs, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            try {
                Log.error((String)("File attachment not found: " + this.file.getCanonicalPath()));
            }
            catch (Throwable throwable) {
                IOUtil.close(fs);
                throw throwable;
            }
            IOUtil.close((Closeable)fs);
        }
        IOUtil.close((Closeable)fs);
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

