/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.dashboardserver;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.polyscope.flightrecorder.FlightRecorder;
import com.ur.polyscope.flightrecorder.FlightRecorderReporter;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.ReportDescription;
import com.ur.util.Waiting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

@ReadOnlyDashboardAction
public class GenerateFlightReportAction
implements DashBoardAction {
    private static final ScriptActionDefinitionParser GENERATE_FR_BY_TYPE = new ScriptActionDefinitionParser("generate flight report <arg>");
    private static final ScriptActionDefinitionParser GENERATE_SYSTEM_FR = new ScriptActionDefinitionParser("generate flight report");
    private FlightRecorder flightRecorder;
    private FlightRecorderReporter flightRecorderReporter;
    private Map<String, FlightRecorderTriggerType> optionsMap;

    @Inject
    public GenerateFlightReportAction(FlightRecorder flightRecorder, FlightRecorderReporter flightRecorderReporter) {
        this.flightRecorder = flightRecorder;
        this.flightRecorderReporter = flightRecorderReporter;
        this.initOptionsMap();
    }

    public boolean canHandleMessage(String s) {
        return GENERATE_SYSTEM_FR.isMatch(s) || GENERATE_FR_BY_TYPE.isMatch(s);
    }

    public String execute(String input) {
        String inputArgument;
        FlightRecorderTriggerType triggerType = FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT;
        if (GENERATE_FR_BY_TYPE.isMatch(input) && (triggerType = this.optionsMap.get((inputArgument = GENERATE_FR_BY_TYPE.getArgument(0, input)).toLowerCase())) == null) {
            return "Invalid Argument \"" + inputArgument + "\". Supported options are " + Arrays.toString(this.optionsMap.keySet().toArray());
        }
        final ReportDescription report = this.flightRecorder.reportIncident(triggerType);
        if (report == null) {
            return "Error: Unable to generate flight report";
        }
        boolean doneInTimeLimit = Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return report.getReportTask().isDone();
            }
        }, (int)5, (TimeUnit)TimeUnit.MINUTES);
        if (!doneInTimeLimit) {
            return "Error: Timed out while generating flight report";
        }
        if (this.flightRecorderReporter.getReport(report.getReportId()) != null) {
            return "Flight Report generated with id: " + report.getReportId();
        }
        return "Error: Unable to generate flight report";
    }

    private void initOptionsMap() {
        this.optionsMap = new HashMap<String, FlightRecorderTriggerType>();
        this.optionsMap.put("software", FlightRecorderTriggerType.SOFTWARE_FAILURE);
        this.optionsMap.put("controller", FlightRecorderTriggerType.CONTROLLER_REPORTED_ERROR);
        this.optionsMap.put("system", FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT);
    }
}

