/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.flightrecorderprobe;

import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FileAttachmentConfiguration;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import com.ur.polyscope.platform.api.PlatformEnvironment;
import com.ur.polyscope.platform.api.SoftwarePlatformType;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class ControllerFilesProbe
implements FlightRecorderProbe {
    private static final String EMBEDDED_METRICS_SOURCE_FOLDER_PATH = "/tmp/metrics/";
    private static final String EMBEDDED_METRICS_TARGET_FOLDER_NAME = "robot_metrics";
    private static final String CONTROLLER_FILES_TARGET_FOLDER_NAME = "urcontrol";
    private static final String CONTROLLER_LOG_NAME = "URControl.log";
    private static final String CONTROLLER_SERVICE_NAME = "urcontrol";
    private static final String CONTROLLER_LOG_TARGET_PREFIX = "URControl.log.";
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public ControllerFilesProbe(FlightRecorderAttachmentFactory attachmentFactory) {
        this.attachmentFactory = attachmentFactory;
    }

    private static String getDotUrcontrolDirectory() {
        return System.getProperty("user.home") + "/.urcontrol";
    }

    public String getName() {
        return "Controller Files Probe";
    }

    public void write(PrintStream out) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector collector = new AttachmentCollector(this.attachmentFactory);
        this.addURControlLogFiles(collector);
        if (PlatformEnvironment.getSoftwarePlatFormType().equals((Object)SoftwarePlatformType.SW6)) {
            this.addControllerLogFilesSW6(collector);
        } else {
            this.addControllerLogFilesSW5(collector);
        }
        this.addEmbeddedMetricsFiles(collector);
        return collector.asList();
    }

    private void addURControlLogFiles(AttachmentCollector collector) {
        File[] files = new File(ControllerFilesProbe.getDotUrcontrolDirectory()).listFiles(file -> !file.isDirectory() && !file.getName().startsWith("joint_motor_calibration") && !file.getName().equals("joint_info.txt"));
        if (files == null) {
            return;
        }
        FileAttachmentConfiguration configuration = this.attachmentFactory.getFileAttachmentConfiguration().setTargetDirectoryPath("urcontrol").setMaxTextFileSize(Integer.MAX_VALUE).setMimeType(MediaType.PLAIN_TEXT_UTF_8.toString());
        for (File eachFile : files) {
            configuration.setFile(eachFile);
            collector.collect(this.attachmentFactory.getTextFileAttachment(configuration));
        }
    }

    private void addControllerLogFilesSW5(AttachmentCollector collector) {
        int logFileNumber = 0;
        FileAttachmentConfiguration configuration = this.attachmentFactory.getFileAttachmentConfiguration();
        configuration.setFile(ControllerFilesProbe.getFile(ControllerFilesProbe.getControllerLogDirectory(), "current")).setTargetDirectoryPath("urcontrol").setTargetFileName(CONTROLLER_LOG_TARGET_PREFIX + logFileNumber).setMaxTextFileSize(Integer.MAX_VALUE).setMimeType(MediaType.PLAIN_TEXT_UTF_8.toString());
        collector.collect(this.attachmentFactory.getTextFileAttachment(configuration));
        ++logFileNumber;
        File[] f = new File(ControllerFilesProbe.getControllerLogDirectory()).listFiles();
        if (f != null) {
            List<File> files = Arrays.asList(f);
            Collections.sort(files);
            Collections.reverse(files);
            for (File eachFile : files) {
                String eachName = eachFile.getName();
                if (!eachName.startsWith("@")) continue;
                configuration.setFile(eachFile).setTargetFileName(CONTROLLER_LOG_TARGET_PREFIX + logFileNumber);
                collector.collect(this.attachmentFactory.getTextFileAttachment(configuration));
                break;
            }
        }
    }

    private void addControllerLogFilesSW6(AttachmentCollector collector) {
        collector.collect(this.attachmentFactory.getShellCommandAttachment(this.getControllerLogBashCommand(), "urcontrol", CONTROLLER_LOG_NAME, MediaType.PLAIN_TEXT_UTF_8.toString()));
    }

    private static File getFile(String directory, String file) {
        return new File(directory + File.separator + file);
    }

    private static String getControllerLogDirectory() {
        if ("root".equals(System.getProperty("user.name"))) {
            return "/tmp/log/urcontrol/";
        }
        return ControllerFilesProbe.getDotUrcontrolDirectory() + "/daemon_" + System.getProperty("user.name") + "/log/";
    }

    private String getControllerLogBashCommand() {
        return "journalctl -u urcontrol --since '2 hours ago' --output=cat";
    }

    private void addEmbeddedMetricsFiles(AttachmentCollector collector) {
        FileAttachmentConfiguration binaryFileConfiguration = this.attachmentFactory.getFileAttachmentConfiguration();
        binaryFileConfiguration.setTargetDirectoryPath(EMBEDDED_METRICS_TARGET_FOLDER_NAME).setMaxTextFileSize(Integer.MAX_VALUE).setMimeType(MediaType.OCTET_STREAM.toString());
        File[] f = new File(EMBEDDED_METRICS_SOURCE_FOLDER_PATH).listFiles();
        if (f != null) {
            for (File eachFile : f) {
                binaryFileConfiguration.setFile(eachFile);
                collector.collect(this.attachmentFactory.getTextFileAttachment(binaryFileConfiguration));
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }
}

