/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.flightrecorderprobe;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class HardwareConfigurationFilesProbe
implements FlightRecorderProbe {
    private static final String JOINT_CONFIGURATION_FILE_NAME = "joint_info.txt";
    private static final String HARDWARE_CONFIGURATION_TARGET_FOLDER_NAME = "urcontrol";
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public HardwareConfigurationFilesProbe(FlightRecorderAttachmentFactory attachmentFactory) {
        this.attachmentFactory = attachmentFactory;
    }

    private static String getDotUrcontrolDirectory() {
        return System.getProperty("user.home") + "/.urcontrol";
    }

    private static File getFile(String directory, String file) {
        return new File(directory + File.separator + file);
    }

    private static File getDotFile(String file) {
        return HardwareConfigurationFilesProbe.getFile(HardwareConfigurationFilesProbe.getDotUrcontrolDirectory(), file);
    }

    public String getName() {
        return "Hardware Configuration Files Probe";
    }

    public void write(PrintStream out) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector r = new AttachmentCollector(this.attachmentFactory);
        r.collect(HardwareConfigurationFilesProbe.getDotFile(JOINT_CONFIGURATION_FILE_NAME), HARDWARE_CONFIGURATION_TARGET_FOLDER_NAME, MediaType.PLAIN_TEXT_UTF_8.toString());
        this.addMotorCalibrationFiles(r);
        return r.asList();
    }

    private void addMotorCalibrationFiles(AttachmentCollector collector) {
        File[] f = new File(HardwareConfigurationFilesProbe.getDotUrcontrolDirectory()).listFiles();
        if (f != null) {
            Iterable matchedLogFiles = Iterables.filter(Arrays.asList(f), (Predicate)new Predicate<File>(){

                public boolean apply(File file) {
                    return file.isFile() && file.getName().startsWith("joint_motor_calibration");
                }
            });
            for (File eachFile : matchedLogFiles) {
                collector.collect(eachFile, HARDWARE_CONFIGURATION_TARGET_FOLDER_NAME, MediaType.PLAIN_TEXT_UTF_8.toString());
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.of(FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT);
    }
}

