/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.flightrecorderprobe;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class HeapDumpFilesProbe
implements FlightRecorderProbe {
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public HeapDumpFilesProbe(FlightRecorderAttachmentFactory attachmentFactory) {
        this.attachmentFactory = attachmentFactory;
    }

    public String getName() {
        return "Heap Dump Files Probe";
    }

    public void write(PrintStream out) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector r = new AttachmentCollector(this.attachmentFactory);
        this.addHeapDumpFiles(r);
        return r.asList();
    }

    private void addHeapDumpFiles(AttachmentCollector collector) {
        File[] f = new File(System.getProperty("user.home")).listFiles();
        if (f != null) {
            Iterable matchedLogFiles = Iterables.filter(Arrays.asList(f), (Predicate)new Predicate<File>(){

                public boolean apply(File file) {
                    return file.isFile() && file.getName().endsWith(".hprof");
                }
            });
            for (File eachFile : matchedLogFiles) {
                collector.collect(eachFile, MediaType.PLAIN_TEXT_UTF_8.toString());
            }
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }
}

