/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.flightrecorderprobe;

import com.google.common.net.MediaType;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class PolyscopeLogProbe
implements FlightRecorderProbe {
    private static final String POLYSCOPE_LOG_NAME = "polyscope.log";
    private static final String POLYSCOPE_SERVICE_NAME = "polyscope";
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public PolyscopeLogProbe(FlightRecorderAttachmentFactory flightRecorderAttachmentFactory) {
        this.attachmentFactory = flightRecorderAttachmentFactory;
    }

    public String getName() {
        return "Polyscope Logging Probe";
    }

    public void write(PrintStream out) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector collector = new AttachmentCollector(this.attachmentFactory);
        collector.collect(this.attachmentFactory.getShellCommandAttachment(this.getPolyscopeLogBashCommand(), POLYSCOPE_LOG_NAME, MediaType.PLAIN_TEXT_UTF_8.toString()));
        return collector.asList();
    }

    private String getPolyscopeLogBashCommand() {
        return "journalctl -u polyscope --since '2 hours ago'";
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }
}

