/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.flightrecorder.internal.flightrecorderprobe;

import com.google.common.io.Files;
import com.google.common.net.MediaType;
import com.ur.disk.Directories;
import com.ur.lang.StringUtils;
import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.AttachmentCollector;
import com.ur.polyscope.flightrecorder.attachment.FileAttachmentConfiguration;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachmentFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class ProgramsAndInstallationsProbe
implements FlightRecorderProbe {
    private static final String TARGET_PROGRAMS_FOLDER_NAME = "programs";
    private static final int SUBFOLDERS_LIMIT = 10;
    private static final Map<String, String> fileTypesCollected = new HashMap<String, String>();
    private final FlightRecorderAttachmentFactory attachmentFactory;

    @Inject
    public ProgramsAndInstallationsProbe(FlightRecorderAttachmentFactory attachmentFactory) {
        this.attachmentFactory = attachmentFactory;
        fileTypesCollected.put("urp", MediaType.GZIP.toString());
        fileTypesCollected.put("script", MediaType.PLAIN_TEXT_UTF_8.toString());
        fileTypesCollected.put("installation", MediaType.GZIP.toString());
        fileTypesCollected.put("variables", MediaType.PLAIN_TEXT_UTF_8.toString());
        fileTypesCollected.put("", MediaType.PLAIN_TEXT_UTF_8.toString());
        for (int i = 0; i < 10; ++i) {
            fileTypesCollected.put("old" + i, MediaType.GZIP.toString());
        }
    }

    public String getName() {
        return "Programs and Installations collector";
    }

    public void write(PrintStream out) {
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        AttachmentCollector attachments = new AttachmentCollector(this.attachmentFactory);
        File[] files = Directories.programs().listFiles(new FilterUsbDrives());
        this.recursivelyCollectFiles(attachments, TARGET_PROGRAMS_FOLDER_NAME, files);
        return attachments.asList();
    }

    private void recursivelyCollectFiles(AttachmentCollector attachments, String targetPath, File[] files) {
        if (files == null || StringUtils.numberOfOccurances((String)File.separator, (String)targetPath) > 10) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                this.recursivelyCollectFiles(attachments, targetPath + File.separator + f.getName(), f.listFiles());
                continue;
            }
            String fileExtension = Files.getFileExtension((String)f.getName());
            if (!fileTypesCollected.keySet().contains(fileExtension)) continue;
            FileAttachmentConfiguration attachmentConfiguration = this.attachmentFactory.getFileAttachmentConfiguration();
            attachmentConfiguration.setTargetDirectoryPath(targetPath).setFile(f).setMaxTextFileSize(Integer.MAX_VALUE).setMimeType(fileTypesCollected.get(fileExtension));
            attachments.collect(this.attachmentFactory.getTextFileAttachment(attachmentConfiguration));
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.of(FlightRecorderTriggerType.SYSTEM_CONFIGURATION_REPORT);
    }

    private static class FilterUsbDrives
    implements FileFilter {
        private FilterUsbDrives() {
        }

        @Override
        public boolean accept(File file) {
            return !file.isDirectory() || !file.getName().startsWith("usbdisk");
        }
    }
}

